/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactivestreams;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.bolt.api.TelemetryApi;
import org.neo4j.driver.internal.reactive.AbstractReactiveSession;
import org.neo4j.driver.internal.reactivestreams.BaseReactiveQueryRunner;
import org.neo4j.driver.internal.reactivestreams.DelegatingReactiveTransactionContext;
import org.neo4j.driver.internal.reactivestreams.InternalReactiveResult;
import org.neo4j.driver.internal.reactivestreams.InternalReactiveTransaction;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.reactivestreams.ReactiveResult;
import org.neo4j.driver.reactivestreams.ReactiveSession;
import org.neo4j.driver.reactivestreams.ReactiveTransaction;
import org.neo4j.driver.reactivestreams.ReactiveTransactionCallback;
import org.reactivestreams.Publisher;

public class InternalReactiveSession
extends AbstractReactiveSession<ReactiveTransaction>
implements ReactiveSession,
BaseReactiveQueryRunner {
    public InternalReactiveSession(NetworkSession session) {
        super(session);
    }

    @Override
    public ReactiveTransaction createTransaction(UnmanagedTransaction unmanagedTransaction) {
        return new InternalReactiveTransaction(unmanagedTransaction);
    }

    @Override
    public Publisher<Void> closeTransaction(ReactiveTransaction transaction, boolean commit) {
        return ((InternalReactiveTransaction)transaction).close(commit);
    }

    @Override
    public Publisher<ReactiveTransaction> beginTransaction(TransactionConfig config) {
        return this.beginTransaction(config, null, new ApiTelemetryWork(TelemetryApi.UNMANAGED_TRANSACTION));
    }

    public Publisher<ReactiveTransaction> beginTransaction(TransactionConfig config, String txType, ApiTelemetryWork apiTelemetryWork) {
        return this.doBeginTransaction(config, txType, apiTelemetryWork);
    }

    @Override
    public <T> Publisher<T> executeRead(ReactiveTransactionCallback<? extends Publisher<T>> callback, TransactionConfig config) {
        return this.runTransaction(AccessMode.READ, tx -> (Publisher)callback.execute(new DelegatingReactiveTransactionContext((ReactiveTransaction)tx)), config);
    }

    @Override
    public <T> Publisher<T> executeWrite(ReactiveTransactionCallback<? extends Publisher<T>> callback, TransactionConfig config) {
        return this.runTransaction(AccessMode.WRITE, tx -> (Publisher)callback.execute(new DelegatingReactiveTransactionContext((ReactiveTransaction)tx)), config);
    }

    @Override
    public Publisher<ReactiveResult> run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    @Override
    public Publisher<ReactiveResult> run(Query query, TransactionConfig config) {
        return this.run(query, config, InternalReactiveResult::new);
    }

    @Override
    public Set<Bookmark> lastBookmarks() {
        return new HashSet<Bookmark>(this.session.lastBookmarks());
    }

    @Override
    public <T> Publisher<T> close() {
        return this.doClose();
    }
}

