/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.messaging.v57;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.internal.bolt.api.GqlError;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.ResponseMessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v5.MessageReaderV5;
import org.neo4j.driver.internal.bolt.basicimpl.packstream.PackInput;
import org.neo4j.driver.types.Type;
import org.neo4j.driver.types.TypeSystem;

public class MessageReaderV57
extends MessageReaderV5 {
    private static final Type MAP_TYPE = TypeSystem.getDefault().MAP();

    public MessageReaderV57(PackInput input) {
        super(input);
    }

    @Override
    protected void unpackFailureMessage(ResponseMessageHandler output) throws IOException {
        Map<String, Value> params = this.unpacker.unpackMap();
        GqlError gqlError = this.unpackGqlError(params);
        output.handleFailureMessage(gqlError);
    }

    protected GqlError unpackGqlError(Map<String, Value> params) {
        Map<String, Value> diagnosticRecord;
        String gqlStatus = params.get("gql_status").asString();
        String statusDescription = params.get("description").asString();
        String code = params.getOrDefault("neo4j_code", Values.value("N/A")).asString();
        String message = params.get("message").asString();
        Value diagnosticRecordValue = params.get("diagnostic_record");
        if (diagnosticRecordValue != null && MAP_TYPE.isTypeOf(diagnosticRecordValue)) {
            boolean containsOperation = diagnosticRecordValue.containsKey("OPERATION");
            boolean containsOperationCode = diagnosticRecordValue.containsKey("OPERATION_CODE");
            boolean containsCurrentSchema = diagnosticRecordValue.containsKey("CURRENT_SCHEMA");
            if (containsOperation && containsOperationCode && containsCurrentSchema) {
                diagnosticRecord = diagnosticRecordValue.asMap(Values::value);
            } else {
                diagnosticRecord = new HashMap<String, Value>(diagnosticRecordValue.asMap(Values::value));
                if (!containsOperation) {
                    diagnosticRecord.put("OPERATION", Values.value(""));
                }
                if (!containsOperationCode) {
                    diagnosticRecord.put("OPERATION_CODE", Values.value("0"));
                }
                if (!containsCurrentSchema) {
                    diagnosticRecord.put("CURRENT_SCHEMA", Values.value("/"));
                }
                diagnosticRecord = Collections.unmodifiableMap(diagnosticRecord);
            }
        } else {
            diagnosticRecord = Map.ofEntries(Map.entry("OPERATION", Values.value("")), Map.entry("OPERATION_CODE", Values.value("0")), Map.entry("CURRENT_SCHEMA", Values.value("/")));
        }
        GqlError gqlError = null;
        Value cause = params.get("cause");
        if (cause != null) {
            if (!MAP_TYPE.isTypeOf(cause)) {
                throw new ProtocolException("Unexpected type");
            }
            gqlError = this.unpackGqlError(cause.asMap(Values::value));
        }
        return new GqlError(gqlStatus, statusDescription, code, message, diagnosticRecord, gqlError);
    }
}

