/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.messaging.v3;

import io.netty.channel.Channel;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.UnsupportedFeatureException;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.BoltAgent;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.ClusterComposition;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.DatabaseNameUtil;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.api.summary.DiscardSummary;
import org.neo4j.driver.internal.bolt.api.summary.PullSummary;
import org.neo4j.driver.internal.bolt.api.summary.RouteSummary;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.BeginTxResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.CommitTxResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.DiscardResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.HelloResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.PullResponseHandlerImpl;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.ResetResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.RollbackTxResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.RunResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.BoltProtocol;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.MessageFormat;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.MessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.PullMessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.BeginMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.CommitMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.DiscardMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.HelloMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.MultiDatabaseUtil;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.PullAllMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.ResetMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.RollbackMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.bolt.basicimpl.spi.Connection;
import org.neo4j.driver.internal.bolt.basicimpl.util.MetadataExtractor;
import org.neo4j.driver.types.MapAccessor;

public class BoltProtocolV3
implements BoltProtocol {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(3, 0);
    public static final BoltProtocol INSTANCE = new BoltProtocolV3();
    public static final MetadataExtractor METADATA_EXTRACTOR = new MetadataExtractor("t_first");
    private static final String ROUTING_CONTEXT = "context";
    private static final String GET_ROUTING_TABLE = "CALL dbms.cluster.routing.getRoutingTable($context)";

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV3();
    }

    @Override
    public CompletionStage<Channel> initializeChannel(Channel channel, String userAgent, BoltAgent boltAgent, Map<String, Value> authMap, RoutingContext routingContext, NotificationConfig notificationConfig, Clock clock, CompletableFuture<Long> latestAuthMillisFuture) {
        Neo4jException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            return CompletableFuture.failedStage(exception);
        }
        HelloMessage message = routingContext.isServerRoutingEnabled() ? new HelloMessage(userAgent, null, authMap, routingContext.toMap(), this.includeDateTimeUtcPatchInHello(), notificationConfig, this.useLegacyNotifications()) : new HelloMessage(userAgent, null, authMap, null, this.includeDateTimeUtcPatchInHello(), notificationConfig, this.useLegacyNotifications());
        CompletableFuture<String> future = new CompletableFuture<String>();
        HelloResponseHandler handler = new HelloResponseHandler(future, channel, clock, latestAuthMillisFuture);
        ChannelAttributes.messageDispatcher(channel).enqueue(handler);
        channel.writeAndFlush((Object)message, channel.voidPromise());
        return future.thenApply(ignored -> channel);
    }

    @Override
    public CompletionStage<Void> route(Connection connection, Map<String, Value> routingContext, Set<String> bookmarks, String databaseName, String impersonatedUser, MessageHandler<RouteSummary> handler, Clock clock, LoggingProvider logging) {
        Query query = new Query(GET_ROUTING_TABLE, Values.parameters(ROUTING_CONTEXT, routingContext).asMap(Values::value));
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.autoCommitTxRunMessage(query.query(), query.parameters(), null, Collections.emptyMap(), DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, Collections.emptySet(), null, NotificationConfig.defaultConfig(), this.useLegacyNotifications(), logging);
        final CompletableFuture<RunSummary> runFuture = new CompletableFuture<RunSummary>();
        RunResponseHandler runHandler = new RunResponseHandler(runFuture, METADATA_EXTRACTOR);
        final CompletableFuture pullFuture = new CompletableFuture();
        final ArrayList records = new ArrayList();
        ((CompletableFuture)((CompletableFuture)runFuture.thenCompose(ignored -> pullFuture)).thenApply(ignored -> {
            Record map = (Record)records.get(0);
            long ttl = map.get("ttl").asLong();
            long expirationTimestamp = clock.millis() + ttl * 1000L;
            if (ttl < 0L || ttl >= 9223372036854775L || expirationTimestamp < 0L) {
                expirationTimestamp = Long.MAX_VALUE;
            }
            LinkedHashSet<BoltServerAddress> readers = new LinkedHashSet<BoltServerAddress>();
            LinkedHashSet<BoltServerAddress> writers = new LinkedHashSet<BoltServerAddress>();
            LinkedHashSet<BoltServerAddress> routers = new LinkedHashSet<BoltServerAddress>();
            for (Map serversMap : map.get("servers").asList(MapAccessor::asMap)) {
                String role = Values.value(serversMap.get("role")).asString();
                for (Object server : Values.value(serversMap.get("addresses")).asList()) {
                    BoltServerAddress address = new BoltServerAddress(Values.value(server).asString());
                    switch (role) {
                        case "WRITE": {
                            writers.add(address);
                            break;
                        }
                        case "READ": {
                            readers.add(address);
                            break;
                        }
                        case "ROUTE": {
                            routers.add(address);
                        }
                    }
                }
            }
            Value db = map.get("db");
            String name = db != null ? (String)db.computeOrDefault(Value::asString, null) : null;
            ClusterComposition clusterComposition = new ClusterComposition(expirationTimestamp, readers, writers, routers, name);
            return new RouteSummaryImpl(clusterComposition);
        })).whenComplete((summary, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((RouteSummary)summary);
            }
        });
        return connection.write(runMessage, runHandler).thenCompose(ignored -> {
            PullAllMessage pullMessage = PullAllMessage.PULL_ALL;
            PullResponseHandlerImpl pullHandler = new PullResponseHandlerImpl(new PullMessageHandler(){

                @Override
                public void onRecord(Value[] fields) {
                    List<String> keys = ((RunSummary)runFuture.join()).keys();
                    records.add(new InternalRecord(keys, fields));
                }

                @Override
                public void onError(Throwable throwable) {
                    pullFuture.completeExceptionally(throwable);
                }

                @Override
                public void onSummary(PullSummary success) {
                    pullFuture.complete(success);
                }
            });
            return connection.write(pullMessage, pullHandler);
        });
    }

    @Override
    public CompletionStage<Void> beginTransaction(Connection connection, DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, Duration txTimeout, Map<String, Value> txMetadata, String txType, NotificationConfig notificationConfig, MessageHandler<Void> handler, LoggingProvider logging) {
        Neo4jException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            return CompletableFuture.failedStage(exception);
        }
        try {
            this.verifyDatabaseNameBeforeTransaction(databaseName);
        }
        catch (Exception error) {
            return CompletableFuture.failedFuture(error);
        }
        CompletableFuture<Void> beginTxFuture = new CompletableFuture<Void>();
        BeginMessage beginMessage = new BeginMessage(bookmarks, txTimeout, txMetadata, databaseName, accessMode, impersonatedUser, txType, notificationConfig, this.useLegacyNotifications(), logging);
        beginTxFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary(null);
            }
        });
        return connection.write(beginMessage, new BeginTxResponseHandler(beginTxFuture));
    }

    @Override
    public CompletionStage<Void> commitTransaction(Connection connection, MessageHandler<String> handler) {
        CompletableFuture<String> commitFuture = new CompletableFuture<String>();
        commitFuture.whenComplete((bookmark, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((String)bookmark);
            }
        });
        return connection.write(CommitMessage.COMMIT, new CommitTxResponseHandler(commitFuture));
    }

    @Override
    public CompletionStage<Void> rollbackTransaction(Connection connection, MessageHandler<Void> handler) {
        CompletableFuture<Void> rollbackFuture = new CompletableFuture<Void>();
        rollbackFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary(null);
            }
        });
        return connection.write(RollbackMessage.ROLLBACK, new RollbackTxResponseHandler(rollbackFuture));
    }

    @Override
    public CompletionStage<Void> reset(Connection connection, MessageHandler<Void> handler) {
        CompletableFuture<Void> resetFuture = new CompletableFuture<Void>();
        resetFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary(null);
            }
        });
        ResetResponseHandler resetHandler = new ResetResponseHandler(resetFuture);
        return connection.write(ResetMessage.RESET, resetHandler);
    }

    @Override
    public CompletionStage<Void> telemetry(Connection connection, Integer api, MessageHandler<Void> handler) {
        return CompletableFuture.failedStage(new UnsupportedFeatureException("telemetry not supported"));
    }

    @Override
    public CompletionStage<Void> runAuto(Connection connection, DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, String query, Map<String, Value> parameters, Set<String> bookmarks, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig, MessageHandler<RunSummary> handler, LoggingProvider logging) {
        try {
            this.verifyDatabaseNameBeforeTransaction(databaseName);
        }
        catch (Exception error) {
            return CompletableFuture.failedFuture(error);
        }
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.autoCommitTxRunMessage(query, parameters, txTimeout, txMetadata, databaseName, accessMode, bookmarks, impersonatedUser, notificationConfig, this.useLegacyNotifications(), logging);
        CompletableFuture<RunSummary> runFuture = new CompletableFuture<RunSummary>();
        runFuture.whenComplete((summary, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((RunSummary)summary);
            }
        });
        RunResponseHandler runHandler = new RunResponseHandler(runFuture, METADATA_EXTRACTOR);
        return connection.write(runMessage, runHandler);
    }

    @Override
    public CompletionStage<Void> run(Connection connection, String query, Map<String, Value> parameters, MessageHandler<RunSummary> handler) {
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.unmanagedTxRunMessage(query, parameters);
        CompletableFuture<RunSummary> runFuture = new CompletableFuture<RunSummary>();
        runFuture.whenComplete((summary, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((RunSummary)summary);
            }
        });
        RunResponseHandler runHandler = new RunResponseHandler(runFuture, METADATA_EXTRACTOR);
        return connection.write(runMessage, runHandler);
    }

    @Override
    public CompletionStage<Void> pull(Connection connection, long qid, long request, PullMessageHandler handler) {
        PullAllMessage pullMessage = PullAllMessage.PULL_ALL;
        PullResponseHandlerImpl pullHandler = new PullResponseHandlerImpl(handler);
        return connection.write(pullMessage, pullHandler);
    }

    @Override
    public CompletionStage<Void> discard(Connection connection, long qid, long number, MessageHandler<DiscardSummary> handler) {
        DiscardMessage discardMessage = new DiscardMessage(number, qid);
        CompletableFuture<DiscardSummary> discardFuture = new CompletableFuture<DiscardSummary>();
        discardFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((DiscardSummary)ignored);
            }
        });
        DiscardResponseHandler discardHandler = new DiscardResponseHandler(discardFuture);
        return connection.write(discardMessage, discardHandler);
    }

    protected void verifyDatabaseNameBeforeTransaction(DatabaseName databaseName) {
        MultiDatabaseUtil.assertEmptyDatabaseName(databaseName, this.version());
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }

    protected boolean includeDateTimeUtcPatchInHello() {
        return false;
    }

    protected Neo4jException verifyNotificationConfigSupported(NotificationConfig notificationConfig) {
        UnsupportedFeatureException exception = null;
        if (notificationConfig != null && !notificationConfig.equals(NotificationConfig.defaultConfig())) {
            exception = new UnsupportedFeatureException(String.format("Notification configuration is not supported on Bolt %s", this.version().toString()));
        }
        return exception;
    }

    protected boolean useLegacyNotifications() {
        return true;
    }

    public record Query(String query, Map<String, Value> parameters) {
    }

    private record RouteSummaryImpl(ClusterComposition clusterComposition) implements RouteSummary
    {
    }
}

