/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.exceptions.TransactionNestingException;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.bolt.api.TelemetryApi;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.reactive.AbstractReactiveSession;
import org.neo4j.driver.internal.reactive.InternalRxResult;
import org.neo4j.driver.internal.reactive.InternalRxTransaction;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactive.RxTransaction;
import org.neo4j.driver.reactive.RxTransactionWork;
import org.reactivestreams.Publisher;

@Deprecated
public class InternalRxSession
extends AbstractReactiveSession<RxTransaction>
implements RxSession {
    public InternalRxSession(NetworkSession session) {
        super(session);
    }

    @Override
    protected RxTransaction createTransaction(UnmanagedTransaction unmanagedTransaction) {
        return new InternalRxTransaction(unmanagedTransaction);
    }

    @Override
    protected Publisher<Void> closeTransaction(RxTransaction transaction, boolean commit) {
        return ((InternalRxTransaction)transaction).close(commit);
    }

    @Override
    public Publisher<RxTransaction> beginTransaction(TransactionConfig config) {
        return this.doBeginTransaction(config, new ApiTelemetryWork(TelemetryApi.UNMANAGED_TRANSACTION));
    }

    @Override
    public <T> Publisher<T> readTransaction(RxTransactionWork<? extends Publisher<T>> work) {
        return this.readTransaction(work, TransactionConfig.empty());
    }

    @Override
    public <T> Publisher<T> readTransaction(RxTransactionWork<? extends Publisher<T>> work, TransactionConfig config) {
        return this.runTransaction(AccessMode.READ, work::execute, config);
    }

    @Override
    public <T> Publisher<T> writeTransaction(RxTransactionWork<? extends Publisher<T>> work) {
        return this.writeTransaction(work, TransactionConfig.empty());
    }

    @Override
    public <T> Publisher<T> writeTransaction(RxTransactionWork<? extends Publisher<T>> work, TransactionConfig config) {
        return this.runTransaction(AccessMode.WRITE, work::execute, config);
    }

    @Override
    public RxResult run(String query, TransactionConfig config) {
        return this.run(new Query(query), config);
    }

    @Override
    public RxResult run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Query(query, parameters), config);
    }

    @Override
    public RxResult run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    @Override
    public RxResult run(Query query, TransactionConfig config) {
        return new InternalRxResult(() -> {
            CompletableFuture<RxResultCursor> resultCursorFuture = new CompletableFuture<RxResultCursor>();
            this.session.runRx(query, config, resultCursorFuture).whenComplete((cursor, completionError) -> {
                if (cursor != null) {
                    resultCursorFuture.complete((RxResultCursor)cursor);
                } else {
                    this.releaseConnectionBeforeReturning(resultCursorFuture, (Throwable)completionError);
                }
            });
            return resultCursorFuture;
        });
    }

    private <T> void releaseConnectionBeforeReturning(CompletableFuture<T> returnFuture, Throwable completionError) {
        Throwable error = Futures.completionExceptionCause(completionError);
        if (error instanceof TransactionNestingException) {
            returnFuture.completeExceptionally(error);
        } else {
            this.session.releaseConnectionAsync().whenComplete((ignored, closeError) -> returnFuture.completeExceptionally(Futures.combineErrors(error, closeError)));
        }
    }

    @Override
    public Bookmark lastBookmark() {
        return InternalBookmark.from(this.session.lastBookmarks());
    }

    @Override
    public <T> Publisher<T> close() {
        return this.doClose();
    }
}

