/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntSupplier;
import org.neo4j.driver.ConnectionPoolMetrics;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.ListenerEvent;
import org.neo4j.driver.internal.metrics.ConnectionPoolMetricsListener;
import org.neo4j.driver.internal.metrics.TimeRecorderListenerEvent;

final class InternalConnectionPoolMetrics
implements ConnectionPoolMetrics,
ConnectionPoolMetricsListener {
    private final BoltServerAddress address;
    private final IntSupplier inUseSupplier;
    private final IntSupplier idleSupplier;
    private final AtomicLong closed = new AtomicLong();
    private final AtomicInteger creating = new AtomicInteger();
    private final AtomicLong created = new AtomicLong();
    private final AtomicLong failedToCreate = new AtomicLong();
    private final AtomicInteger acquiring = new AtomicInteger();
    private final AtomicLong acquired = new AtomicLong();
    private final AtomicLong timedOutToAcquire = new AtomicLong();
    private final AtomicLong totalAcquisitionTime = new AtomicLong();
    private final AtomicLong totalConnectionTime = new AtomicLong();
    private final AtomicLong totalInUseTime = new AtomicLong();
    private final AtomicLong totalInUseCount = new AtomicLong();
    private final String id;

    InternalConnectionPoolMetrics(String poolId, BoltServerAddress address, IntSupplier inUseSupplier, IntSupplier idleSupplier) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(inUseSupplier);
        Objects.requireNonNull(idleSupplier);
        this.id = poolId;
        this.address = address;
        this.inUseSupplier = inUseSupplier;
        this.idleSupplier = idleSupplier;
    }

    @Override
    public void beforeCreating(ListenerEvent<?> connEvent) {
        this.creating.incrementAndGet();
        connEvent.start();
    }

    @Override
    public void afterFailedToCreate() {
        this.failedToCreate.incrementAndGet();
        this.creating.decrementAndGet();
    }

    @Override
    public void afterCreated(ListenerEvent<?> connEvent) {
        this.created.incrementAndGet();
        this.creating.decrementAndGet();
        long sample = ((TimeRecorderListenerEvent)connEvent).getSample();
        this.totalConnectionTime.addAndGet(sample);
    }

    @Override
    public void afterClosed() {
        this.closed.incrementAndGet();
    }

    @Override
    public void beforeAcquiringOrCreating(ListenerEvent<?> acquireEvent) {
        acquireEvent.start();
        this.acquiring.incrementAndGet();
    }

    @Override
    public void afterAcquiringOrCreating() {
        this.acquiring.decrementAndGet();
    }

    @Override
    public void afterAcquiredOrCreated(ListenerEvent<?> acquireEvent) {
        this.acquired.incrementAndGet();
        long sample = ((TimeRecorderListenerEvent)acquireEvent).getSample();
        this.totalAcquisitionTime.addAndGet(sample);
    }

    @Override
    public void afterTimedOutToAcquireOrCreate() {
        this.timedOutToAcquire.incrementAndGet();
    }

    @Override
    public void acquired(ListenerEvent<?> inUseEvent) {
        inUseEvent.start();
    }

    @Override
    public void released(ListenerEvent<?> inUseEvent) {
        this.totalInUseCount.incrementAndGet();
        long sample = ((TimeRecorderListenerEvent)inUseEvent).getSample();
        this.totalInUseTime.addAndGet(sample);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public int inUse() {
        return this.inUseSupplier.getAsInt();
    }

    @Override
    public int idle() {
        return this.idleSupplier.getAsInt();
    }

    @Override
    public int creating() {
        return this.creating.get();
    }

    @Override
    public long created() {
        return this.created.get();
    }

    @Override
    public long failedToCreate() {
        return this.failedToCreate.get();
    }

    @Override
    public long timedOutToAcquire() {
        return this.timedOutToAcquire.get();
    }

    @Override
    public long totalAcquisitionTime() {
        return this.totalAcquisitionTime.get();
    }

    @Override
    public long totalConnectionTime() {
        return this.totalConnectionTime.get();
    }

    @Override
    public long totalInUseTime() {
        return this.totalInUseTime.get();
    }

    @Override
    public long totalInUseCount() {
        return this.totalInUseCount.get();
    }

    @Override
    public long closed() {
        return this.closed.get();
    }

    @Override
    public int acquiring() {
        return this.acquiring.get();
    }

    @Override
    public long acquired() {
        return this.acquired.get();
    }

    public String toString() {
        return String.format("%s=[created=%s, closed=%s, creating=%s, failedToCreate=%s, acquiring=%s, acquired=%s, timedOutToAcquire=%s, inUse=%s, idle=%s, totalAcquisitionTime=%s, totalConnectionTime=%s, totalInUseTime=%s, totalInUseCount=%s]", this.id(), this.created(), this.closed(), this.creating(), this.failedToCreate(), this.acquiring(), this.acquired(), this.timedOutToAcquire(), this.inUse(), this.idle(), this.totalAcquisitionTime(), this.totalConnectionTime(), this.totalInUseTime(), this.totalInUseCount());
    }

    public BoltServerAddress getAddress() {
        return this.address;
    }
}

