/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.routedimpl;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.AuthData;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltConnectionState;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.GqlStatusError;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.ResponseHandler;
import org.neo4j.driver.internal.bolt.api.TelemetryApi;
import org.neo4j.driver.internal.bolt.api.TransactionType;
import org.neo4j.driver.internal.bolt.api.summary.BeginSummary;
import org.neo4j.driver.internal.bolt.api.summary.CommitSummary;
import org.neo4j.driver.internal.bolt.api.summary.DiscardSummary;
import org.neo4j.driver.internal.bolt.api.summary.LogoffSummary;
import org.neo4j.driver.internal.bolt.api.summary.LogonSummary;
import org.neo4j.driver.internal.bolt.api.summary.PullSummary;
import org.neo4j.driver.internal.bolt.api.summary.ResetSummary;
import org.neo4j.driver.internal.bolt.api.summary.RollbackSummary;
import org.neo4j.driver.internal.bolt.api.summary.RouteSummary;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.bolt.api.summary.TelemetrySummary;
import org.neo4j.driver.internal.bolt.routedimpl.RoutedBoltConnectionProvider;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.bolt.routedimpl.util.FutureUtil;

public class RoutedBoltConnection
implements BoltConnection {
    private final BoltConnection delegate;
    private final RoutingTableHandler routingTableHandler;
    private final AccessMode accessMode;
    private final RoutedBoltConnectionProvider provider;

    public RoutedBoltConnection(BoltConnection delegate, RoutingTableHandler routingTableHandler, AccessMode accessMode, RoutedBoltConnectionProvider provider) {
        this.delegate = Objects.requireNonNull(delegate);
        this.routingTableHandler = Objects.requireNonNull(routingTableHandler);
        this.accessMode = Objects.requireNonNull(accessMode);
        this.provider = Objects.requireNonNull(provider);
    }

    @Override
    public CompletionStage<BoltConnection> route(DatabaseName databaseName, String impersonatedUser, Set<String> bookmarks) {
        return this.delegate.route(databaseName, impersonatedUser, bookmarks).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> beginTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, String txType, NotificationConfig notificationConfig) {
        return this.delegate.beginTransaction(databaseName, accessMode, impersonatedUser, bookmarks, transactionType, txTimeout, txMetadata, txType, notificationConfig).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> runInAutoCommitTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        return this.delegate.runInAutoCommitTransaction(databaseName, accessMode, impersonatedUser, bookmarks, query, parameters, txTimeout, txMetadata, notificationConfig).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> run(String query, Map<String, Value> parameters) {
        return this.delegate.run(query, parameters).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> pull(long qid, long request) {
        return this.delegate.pull(qid, request).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> discard(long qid, long number) {
        return this.delegate.discard(qid, number).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> commit() {
        return this.delegate.commit().thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> rollback() {
        return this.delegate.rollback().thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> reset() {
        return this.delegate.reset().thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> logoff() {
        return this.delegate.logoff().thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> logon(Map<String, Value> authMap) {
        return this.delegate.logon(authMap).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> telemetry(TelemetryApi telemetryApi) {
        return this.delegate.telemetry(telemetryApi).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> clear() {
        return this.delegate.clear();
    }

    @Override
    public CompletionStage<Void> flush(final ResponseHandler handler) {
        return this.delegate.flush(new ResponseHandler(){
            private Throwable error;

            @Override
            public void onError(Throwable throwable) {
                if (this.error == null) {
                    this.error = RoutedBoltConnection.this.handledError(throwable);
                    handler.onError(this.error);
                }
            }

            @Override
            public void onBeginSummary(BeginSummary summary) {
                handler.onBeginSummary(summary);
            }

            @Override
            public void onRunSummary(RunSummary summary) {
                handler.onRunSummary(summary);
            }

            @Override
            public void onRecord(Value[] fields) {
                handler.onRecord(fields);
            }

            @Override
            public void onPullSummary(PullSummary summary) {
                handler.onPullSummary(summary);
            }

            @Override
            public void onDiscardSummary(DiscardSummary summary) {
                handler.onDiscardSummary(summary);
            }

            @Override
            public void onCommitSummary(CommitSummary summary) {
                handler.onCommitSummary(summary);
            }

            @Override
            public void onRollbackSummary(RollbackSummary summary) {
                handler.onRollbackSummary(summary);
            }

            @Override
            public void onResetSummary(ResetSummary summary) {
                handler.onResetSummary(summary);
            }

            @Override
            public void onRouteSummary(RouteSummary summary) {
                handler.onRouteSummary(summary);
            }

            @Override
            public void onLogoffSummary(LogoffSummary summary) {
                handler.onLogoffSummary(summary);
            }

            @Override
            public void onLogonSummary(LogonSummary summary) {
                handler.onLogonSummary(summary);
            }

            @Override
            public void onTelemetrySummary(TelemetrySummary summary) {
                handler.onTelemetrySummary(summary);
            }

            @Override
            public void onIgnored() {
                handler.onIgnored();
            }

            @Override
            public void onComplete() {
                handler.onComplete();
            }
        });
    }

    @Override
    public CompletionStage<Void> forceClose(String reason) {
        return this.delegate.forceClose(reason);
    }

    @Override
    public CompletionStage<Void> close() {
        this.provider.decreaseCount(this.serverAddress());
        return this.delegate.close();
    }

    @Override
    public BoltConnectionState state() {
        return this.delegate.state();
    }

    @Override
    public CompletionStage<AuthData> authData() {
        return this.delegate.authData();
    }

    @Override
    public String serverAgent() {
        return this.delegate.serverAgent();
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    @Override
    public BoltProtocolVersion protocolVersion() {
        return this.delegate.protocolVersion();
    }

    @Override
    public boolean telemetrySupported() {
        return this.delegate.telemetrySupported();
    }

    private Throwable handledError(Throwable receivedError) {
        Throwable error = FutureUtil.completionExceptionCause(receivedError);
        if (error instanceof ServiceUnavailableException) {
            return this.handledServiceUnavailableException((ServiceUnavailableException)error);
        }
        if (error instanceof ClientException) {
            return this.handledClientException((ClientException)error);
        }
        if (error instanceof TransientException) {
            return this.handledTransientException((TransientException)error);
        }
        return error;
    }

    private Throwable handledServiceUnavailableException(ServiceUnavailableException e) {
        this.routingTableHandler.onConnectionFailure(this.serverAddress());
        return new SessionExpiredException(String.format("Server at %s is no longer available", this.serverAddress()), e);
    }

    private Throwable handledTransientException(TransientException e) {
        String errorCode = e.code();
        if (Objects.equals(errorCode, "Neo.TransientError.General.DatabaseUnavailable")) {
            this.routingTableHandler.onConnectionFailure(this.serverAddress());
        }
        return e;
    }

    private Throwable handledClientException(ClientException e) {
        if (RoutedBoltConnection.isFailureToWrite(e)) {
            switch (this.accessMode) {
                case READ: {
                    String message = "Write queries cannot be performed in READ access mode.";
                    return new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                }
                case WRITE: {
                    this.routingTableHandler.onWriteFailure(this.serverAddress());
                    return new SessionExpiredException(String.format("Server at %s no longer accepts writes", this.serverAddress()));
                }
            }
            throw new IllegalArgumentException(this.serverAddress() + " not supported.");
        }
        return e;
    }

    private static boolean isFailureToWrite(ClientException e) {
        String errorCode = e.code();
        return Objects.equals(errorCode, "Neo.ClientError.Cluster.NotALeader") || Objects.equals(errorCode, "Neo.ClientError.General.ForbiddenOnReadOnlyDatabase");
    }
}

