/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.TransactionNestingException;
import org.neo4j.driver.exceptions.UnsupportedFeatureException;
import org.neo4j.driver.internal.DatabaseBookmark;
import org.neo4j.driver.internal.FailableCursor;
import org.neo4j.driver.internal.NotificationConfigMapper;
import org.neo4j.driver.internal.async.BoltConnectionWithAuthTokenManager;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.bolt.api.AuthData;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltConnectionState;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.DatabaseNameUtil;
import org.neo4j.driver.internal.bolt.api.GqlStatusError;
import org.neo4j.driver.internal.bolt.api.ResponseHandler;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.bolt.api.TelemetryApi;
import org.neo4j.driver.internal.bolt.api.TransactionType;
import org.neo4j.driver.internal.bolt.api.exception.MinVersionAcquisitionException;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.cursor.DisposableResultCursorImpl;
import org.neo4j.driver.internal.cursor.ResultCursorImpl;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursorImpl;
import org.neo4j.driver.internal.logging.PrefixedLogger;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.security.BoltSecurityPlanManager;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.internal.util.Futures;

public class NetworkSession {
    private final BoltSecurityPlanManager securityPlanManager;
    private final BoltConnectionProvider boltConnectionProvider;
    private final NetworkSessionConnectionContext connectionContext;
    private final AccessMode mode;
    private final RetryLogic retryLogic;
    private final Logging logging;
    protected final Logger log;
    private final long fetchSize;
    private volatile CompletionStage<UnmanagedTransaction> transactionStage = Futures.completedWithNull();
    private volatile CompletionStage<BoltConnectionWithCloseTracking> connectionStage = Futures.completedWithNull();
    private volatile CompletionStage<? extends FailableCursor> resultCursorStage = Futures.completedWithNull();
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final BookmarkManager bookmarkManager;
    private volatile Set<Bookmark> lastUsedBookmarks = Collections.emptySet();
    private volatile Set<Bookmark> lastReceivedBookmarks;
    private final org.neo4j.driver.internal.bolt.api.NotificationConfig driverNotificationConfig;
    private final org.neo4j.driver.internal.bolt.api.NotificationConfig notificationConfig;
    private final boolean telemetryDisabled;
    private final AuthTokenManager authTokenManager;

    public NetworkSession(BoltSecurityPlanManager securityPlanManager, BoltConnectionProvider boltConnectionProvider, RetryLogic retryLogic, DatabaseName databaseName, AccessMode mode, Set<Bookmark> bookmarks, String impersonatedUser, long fetchSize, Logging logging, BookmarkManager bookmarkManager, NotificationConfig driverNotificationConfig, NotificationConfig notificationConfig, AuthToken overrideAuthToken, boolean telemetryDisabled, AuthTokenManager authTokenManager) {
        Objects.requireNonNull(bookmarks, "bookmarks may not be null");
        Objects.requireNonNull(bookmarkManager, "bookmarkManager may not be null");
        this.securityPlanManager = Objects.requireNonNull(securityPlanManager);
        this.boltConnectionProvider = Objects.requireNonNull(boltConnectionProvider);
        this.mode = mode;
        this.retryLogic = retryLogic;
        this.logging = logging;
        this.log = new PrefixedLogger("[" + this.hashCode() + "]", logging.getLog(this.getClass()));
        CompletableFuture<DatabaseName> databaseNameFuture = databaseName.databaseName().map(ignored -> CompletableFuture.completedFuture(databaseName)).orElse(new CompletableFuture());
        this.bookmarkManager = bookmarkManager;
        this.lastReceivedBookmarks = bookmarks;
        this.connectionContext = new NetworkSessionConnectionContext(databaseNameFuture, this.determineBookmarks(false), impersonatedUser, overrideAuthToken);
        this.fetchSize = fetchSize;
        this.driverNotificationConfig = NotificationConfigMapper.map(driverNotificationConfig);
        this.notificationConfig = NotificationConfigMapper.map(notificationConfig);
        this.telemetryDisabled = telemetryDisabled;
        this.authTokenManager = authTokenManager;
    }

    public CompletionStage<ResultCursor> runAsync(Query query, TransactionConfig config) {
        this.ensureSessionIsOpen();
        CompletionStage disposable = this.ensureNoOpenTxBeforeRunningQuery().thenCompose(ignore -> this.acquireConnection(this.mode)).thenCompose(connection -> {
            Map<String, Value> parameters = query.parameters().asMap(Values::value);
            ApiTelemetryWork apiTelemetryWork = new ApiTelemetryWork(TelemetryApi.AUTO_COMMIT_TRANSACTION);
            apiTelemetryWork.setEnabled(!this.telemetryDisabled);
            ResultCursorImpl resultCursor = new ResultCursorImpl((BoltConnection)connection, query, this.fetchSize, null, this::handleNewBookmark, true, () -> null, null, null);
            CompletionStage<DisposableResultCursorImpl> cursorStage = apiTelemetryWork.pipelineTelemetryIfEnabled((BoltConnection)connection).thenCompose(conn -> conn.runInAutoCommitTransaction(this.connectionContext.databaseNameFuture.getNow(null), this.asBoltAccessMode(this.mode), this.connectionContext.impersonatedUser, this.determineBookmarks(true).stream().map(Bookmark::value).collect(Collectors.toSet()), query.text(), parameters, config.timeout(), config.metadata(), this.notificationConfig)).thenCompose(conn -> conn.pull(-1L, this.fetchSize)).thenCompose(conn -> conn.flush(resultCursor)).thenCompose(ignored -> resultCursor.resultCursor()).handle((resultCursorImpl, throwable) -> {
                Throwable error = Futures.completionExceptionCause(throwable);
                if (error != null) {
                    return connection.close().handle((ignored, closeError) -> {
                        if (closeError != null) {
                            error.addSuppressed((Throwable)closeError);
                        }
                        if (error instanceof RuntimeException) {
                            RuntimeException runtimeException = (RuntimeException)error;
                            throw runtimeException;
                        }
                        throw new CompletionException(error);
                    });
                }
                return CompletableFuture.completedStage(resultCursorImpl);
            }).thenCompose(Function.identity()).thenApply(DisposableResultCursorImpl::new);
            return cursorStage.thenApply(Function.identity());
        });
        this.resultCursorStage = disposable.exceptionally(error -> null);
        return disposable.thenApply(Function.identity());
    }

    public CompletionStage<RxResultCursor> runRx(Query query, TransactionConfig config, CompletionStage<RxResultCursor> cursorPublishStage) {
        this.ensureSessionIsOpen();
        return this.ensureNoOpenTxBeforeRunningQuery().thenCompose(ignore -> this.acquireConnection(this.mode)).thenCompose(connection -> {
            Map<String, Value> parameters = query.parameters().asMap(Values::value);
            ApiTelemetryWork apiTelemetryWork = new ApiTelemetryWork(TelemetryApi.AUTO_COMMIT_TRANSACTION);
            apiTelemetryWork.setEnabled(!this.telemetryDisabled);
            AtomicBoolean runFailed = new AtomicBoolean(false);
            RunRxResponseHandler responseHandler = new RunRxResponseHandler((BoltConnection)connection, query, this::handleNewBookmark, runFailed);
            CompletionStage cursorStage = apiTelemetryWork.pipelineTelemetryIfEnabled((BoltConnection)connection).thenCompose(conn -> conn.runInAutoCommitTransaction(this.connectionContext.databaseNameFuture.getNow(null), this.asBoltAccessMode(this.mode), this.connectionContext.impersonatedUser, this.determineBookmarks(true).stream().map(Bookmark::value).collect(Collectors.toSet()), query.text(), parameters, config.timeout(), config.metadata(), this.notificationConfig)).thenCompose(conn -> conn.flush(responseHandler)).thenCompose(ignored -> responseHandler.cursorFuture).handle((resultCursor, throwable) -> {
                Throwable error = Futures.completionExceptionCause(throwable);
                if (error != null) {
                    return connection.close().handle((ignored, closeError) -> {
                        if (closeError != null) {
                            error.addSuppressed((Throwable)closeError);
                        }
                        if (error instanceof RuntimeException) {
                            RuntimeException runtimeException = (RuntimeException)error;
                            throw runtimeException;
                        }
                        throw new CompletionException(error);
                    });
                }
                if (runFailed.get()) {
                    return connection.close().handle((ignored1, ignored2) -> resultCursor);
                }
                return CompletableFuture.completedStage(resultCursor);
            }).thenCompose(Function.identity());
            this.resultCursorStage = cursorStage.exceptionally(error -> null);
            return cursorStage.thenApply(Function.identity());
        });
    }

    public CompletionStage<UnmanagedTransaction> beginTransactionAsync(TransactionConfig config, ApiTelemetryWork apiTelemetryWork) {
        return this.beginTransactionAsync(this.mode, config, null, apiTelemetryWork, true);
    }

    public CompletionStage<UnmanagedTransaction> beginTransactionAsync(TransactionConfig config, String txType, ApiTelemetryWork apiTelemetryWork) {
        return this.beginTransactionAsync(this.mode, config, txType, apiTelemetryWork, true);
    }

    public CompletionStage<UnmanagedTransaction> beginTransactionAsync(AccessMode mode, TransactionConfig config, ApiTelemetryWork apiTelemetryWork) {
        return this.beginTransactionAsync(mode, config, null, apiTelemetryWork, true);
    }

    public CompletionStage<UnmanagedTransaction> beginTransactionAsync(AccessMode mode, TransactionConfig config, String txType, ApiTelemetryWork apiTelemetryWork, boolean flush) {
        this.ensureSessionIsOpen();
        apiTelemetryWork.setEnabled(!this.telemetryDisabled);
        CompletionStage<UnmanagedTransaction> newTransactionStage = this.ensureNoOpenTxBeforeStartingTx().thenCompose(ignore -> this.acquireConnection(mode)).thenCompose(connection -> {
            UnmanagedTransaction tx = new UnmanagedTransaction((BoltConnection)connection, this.connectionContext.databaseNameFuture.getNow(null), this.asBoltAccessMode(mode), this.connectionContext.impersonatedUser, this::handleNewBookmark, this.fetchSize, this.notificationConfig, apiTelemetryWork, this.logging);
            return tx.beginAsync(this.determineBookmarks(true), config, txType, flush);
        });
        CompletionStage<UnmanagedTransaction> currentTransactionStage = this.transactionStage;
        this.transactionStage = newTransactionStage.exceptionally(error -> null).thenCompose(tx -> {
            if (tx == null) {
                return currentTransactionStage;
            }
            return CompletableFuture.completedFuture(tx);
        });
        return newTransactionStage;
    }

    public CompletionStage<Void> resetAsync() {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                tx.markTerminated(null);
            }
        }).thenCompose(ignore -> this.connectionStage).thenCompose(connection -> {
            if (connection != null && !connection.closed.get()) {
                final CompletableFuture future = new CompletableFuture();
                return connection.reset().thenCompose(conn -> conn.flush(new ResponseHandler(){

                    @Override
                    public void onError(Throwable throwable) {
                        future.completeExceptionally(throwable);
                    }

                    @Override
                    public void onComplete() {
                        future.complete(null);
                    }
                })).thenCompose(ignored -> future);
            }
            return Futures.completedWithNull();
        });
    }

    public RetryLogic retryLogic() {
        return this.retryLogic;
    }

    public Set<Bookmark> lastBookmarks() {
        return this.lastReceivedBookmarks;
    }

    public CompletionStage<Void> releaseConnectionAsync() {
        return this.connectionStage.thenCompose(connection -> {
            if (connection != null) {
                return connection.close();
            }
            return Futures.completedWithNull();
        });
    }

    public CompletionStage<BoltConnection> connectionAsync() {
        return this.connectionStage.thenApply(Function.identity());
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public CompletionStage<Void> closeAsync() {
        if (this.open.compareAndSet(true, false)) {
            return this.resultCursorStage.thenCompose(cursor -> {
                if (cursor != null) {
                    return cursor.discardAllFailureAsync();
                }
                return Futures.completedWithNull();
            }).thenCompose(cursorError -> this.closeTransactionAndReleaseConnection().thenApply(txCloseError -> {
                CompletionException combinedError = Futures.combineErrors(cursorError, txCloseError);
                if (combinedError != null) {
                    throw combinedError;
                }
                return null;
            }));
        }
        return Futures.completedWithNull();
    }

    protected CompletionStage<Boolean> currentConnectionIsOpen() {
        return this.connectionStage.handle((connection, error) -> error == null && connection != null && !connection.closed.get());
    }

    private org.neo4j.driver.internal.bolt.api.AccessMode asBoltAccessMode(AccessMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case AccessMode.WRITE -> org.neo4j.driver.internal.bolt.api.AccessMode.WRITE;
            case AccessMode.READ -> org.neo4j.driver.internal.bolt.api.AccessMode.READ;
        };
    }

    private CompletionStage<BoltConnectionWithCloseTracking> acquireConnection(AccessMode mode) {
        CompletionStage<BoltConnectionWithCloseTracking> currentConnectionStage = this.connectionStage;
        CompletionStage<BoltConnectionWithCloseTracking> newConnectionStage = this.resultCursorStage.thenCompose(cursor -> {
            if (cursor == null) {
                return Futures.completedWithNull();
            }
            return cursor.pullAllFailureAsync();
        }).thenCompose(error -> {
            if (error == null) {
                return currentConnectionStage.exceptionally(ignore -> null);
            }
            throw new CompletionException((Throwable)error);
        }).thenCompose(ignored -> {
            Supplier<CompletionStage> tokenStageSupplier;
            AuthToken overrideAuthToken;
            DatabaseName databaseName = this.connectionContext.databaseNameFuture.getNow(null);
            AtomicReference<BoltProtocolVersion> minVersion = new AtomicReference<BoltProtocolVersion>();
            if (this.connectionContext.impersonatedUser() != null) {
                minVersion.set(new BoltProtocolVersion(4, 4));
            }
            if ((overrideAuthToken = this.connectionContext.overrideAuthToken()) != null) {
                tokenStageSupplier = () -> CompletableFuture.completedStage(this.connectionContext.authToken).thenApply(token -> ((InternalAuthToken)token).toMap());
                minVersion.set(new BoltProtocolVersion(5, 1));
            } else {
                tokenStageSupplier = () -> this.authTokenManager.getToken().thenApply(token -> ((InternalAuthToken)token).toMap());
            }
            return this.securityPlanManager.plan().thenCompose(securityPlan -> this.boltConnectionProvider.connect((SecurityPlan)securityPlan, databaseName, (Supplier<CompletionStage<Map<String, Value>>>)tokenStageSupplier, switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case AccessMode.WRITE -> org.neo4j.driver.internal.bolt.api.AccessMode.WRITE;
                case AccessMode.READ -> org.neo4j.driver.internal.bolt.api.AccessMode.READ;
            }, this.connectionContext.rediscoveryBookmarks().stream().map(Bookmark::value).collect(Collectors.toSet()), this.connectionContext.impersonatedUser(), (BoltProtocolVersion)minVersion.get(), this.driverNotificationConfig, name -> this.connectionContext.databaseNameFuture().complete(name == null ? DatabaseNameUtil.defaultDatabase() : name)).thenApply(connection -> new BoltConnectionWithAuthTokenManager((BoltConnection)connection, overrideAuthToken != null ? new AuthTokenManager(){

                @Override
                public CompletionStage<AuthToken> getToken() {
                    return null;
                }

                @Override
                public boolean handleSecurityException(AuthToken authToken, SecurityException exception) {
                    return false;
                }
            } : this.authTokenManager)).thenApply(BoltConnectionWithCloseTracking::new).exceptionally(throwable -> {
                if ((throwable = Futures.completionExceptionCause(throwable)) instanceof TimeoutException) {
                    throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(throwable.getMessage()), "N/A", throwable.getMessage(), GqlStatusError.DIAGNOSTIC_RECORD, (Throwable)throwable);
                }
                if (throwable instanceof MinVersionAcquisitionException) {
                    MinVersionAcquisitionException minVersionAcquisitionException = (MinVersionAcquisitionException)throwable;
                    if (overrideAuthToken == null && this.connectionContext.impersonatedUser() != null) {
                        String message = "Detected connection that does not support impersonation, please make sure to have all servers running 4.4 version or above and communicating over Bolt version 4.4 or above when using impersonation feature";
                        throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                    }
                    throw new CompletionException(new UnsupportedFeatureException(String.format("Detected Bolt %s connection that does not support the auth token override feature, please make sure to have all servers communicating over Bolt 5.1 or above to use the feature", minVersionAcquisitionException.version())));
                }
                throw new CompletionException((Throwable)throwable);
            }));
        });
        this.connectionStage = newConnectionStage.exceptionally(error -> null);
        return newConnectionStage;
    }

    private CompletionStage<Throwable> closeTransactionAndReleaseConnection() {
        return this.existingTransactionOrNull().thenCompose(tx -> {
            if (tx != null) {
                return tx.closeAsync().thenApply(ignore -> null).exceptionally(Function.identity());
            }
            return Futures.completedWithNull();
        }).thenCompose(txCloseError -> this.releaseConnectionAsync().thenApply(ignore -> txCloseError));
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeRunningQuery() {
        return this.ensureNoOpenTx("Queries cannot be run directly on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeStartingTx() {
        return this.ensureNoOpenTx("You cannot begin a transaction on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTx(String errorMessage) {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                throw new TransactionNestingException(errorMessage);
            }
        });
    }

    private CompletionStage<UnmanagedTransaction> existingTransactionOrNull() {
        return this.transactionStage.exceptionally(error -> null).thenApply(tx -> tx != null && tx.isOpen() ? tx : null);
    }

    private void ensureSessionIsOpen() {
        if (!this.open.get()) {
            String message = "No more interaction with this session are allowed as the current session is already closed. ";
            throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
        }
    }

    private void handleNewBookmark(DatabaseBookmark databaseBookmark) {
        this.assertDatabaseNameFutureIsDone();
        Bookmark bookmark = databaseBookmark.bookmark();
        if (bookmark != null) {
            Set<Bookmark> bookmarks = Set.of(bookmark);
            this.lastReceivedBookmarks = bookmarks;
            this.bookmarkManager.updateBookmarks(this.lastUsedBookmarks, bookmarks);
        }
    }

    private Set<Bookmark> determineBookmarks(boolean updateLastUsed) {
        HashSet<Bookmark> bookmarks = new HashSet<Bookmark>(this.bookmarkManager.getBookmarks());
        if (updateLastUsed) {
            this.lastUsedBookmarks = Collections.unmodifiableSet(bookmarks);
        }
        bookmarks.addAll(this.lastReceivedBookmarks);
        return bookmarks;
    }

    private void assertDatabaseNameFutureIsDone() {
        if (!this.connectionContext.databaseNameFuture().isDone()) {
            throw new IllegalStateException("Illegal internal state encountered, database name future is not done.");
        }
    }

    private static class NetworkSessionConnectionContext
    implements ConnectionContext {
        private final CompletableFuture<DatabaseName> databaseNameFuture;
        private final Set<Bookmark> rediscoveryBookmarks;
        private final String impersonatedUser;
        private final AuthToken authToken;

        private NetworkSessionConnectionContext(CompletableFuture<DatabaseName> databaseNameFuture, Set<Bookmark> bookmarks, String impersonatedUser, AuthToken authToken) {
            this.databaseNameFuture = databaseNameFuture;
            this.rediscoveryBookmarks = bookmarks;
            this.impersonatedUser = impersonatedUser;
            this.authToken = authToken;
        }

        @Override
        public CompletableFuture<DatabaseName> databaseNameFuture() {
            return this.databaseNameFuture;
        }

        @Override
        public Set<Bookmark> rediscoveryBookmarks() {
            return this.rediscoveryBookmarks;
        }

        @Override
        public String impersonatedUser() {
            return this.impersonatedUser;
        }

        @Override
        public AuthToken overrideAuthToken() {
            return this.authToken;
        }
    }

    private static class BoltConnectionWithCloseTracking
    implements BoltConnection {
        private final BoltConnection connection;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        private BoltConnectionWithCloseTracking(BoltConnection connection) {
            this.connection = connection;
        }

        @Override
        public CompletionStage<BoltConnection> route(DatabaseName databaseName, String impersonatedUser, Set<String> bookmarks) {
            return this.connection.route(databaseName, impersonatedUser, bookmarks);
        }

        @Override
        public CompletionStage<BoltConnection> beginTransaction(DatabaseName databaseName, org.neo4j.driver.internal.bolt.api.AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, String txType, org.neo4j.driver.internal.bolt.api.NotificationConfig notificationConfig) {
            return this.connection.beginTransaction(databaseName, accessMode, impersonatedUser, bookmarks, transactionType, txTimeout, txMetadata, txType, notificationConfig);
        }

        @Override
        public CompletionStage<BoltConnection> runInAutoCommitTransaction(DatabaseName databaseName, org.neo4j.driver.internal.bolt.api.AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, org.neo4j.driver.internal.bolt.api.NotificationConfig notificationConfig) {
            return this.connection.runInAutoCommitTransaction(databaseName, accessMode, impersonatedUser, bookmarks, query, parameters, txTimeout, txMetadata, notificationConfig);
        }

        @Override
        public CompletionStage<BoltConnection> run(String query, Map<String, Value> parameters) {
            return this.connection.run(query, parameters);
        }

        @Override
        public CompletionStage<BoltConnection> pull(long qid, long request) {
            return this.connection.pull(qid, request);
        }

        @Override
        public CompletionStage<BoltConnection> discard(long qid, long number) {
            return this.connection.discard(qid, number);
        }

        @Override
        public CompletionStage<BoltConnection> commit() {
            return this.connection.commit();
        }

        @Override
        public CompletionStage<BoltConnection> rollback() {
            return this.connection.rollback();
        }

        @Override
        public CompletionStage<BoltConnection> reset() {
            return this.connection.reset();
        }

        @Override
        public CompletionStage<BoltConnection> logoff() {
            return this.connection.logoff();
        }

        @Override
        public CompletionStage<BoltConnection> logon(Map<String, Value> authMap) {
            return this.connection.logon(authMap);
        }

        @Override
        public CompletionStage<BoltConnection> telemetry(TelemetryApi telemetryApi) {
            return this.connection.telemetry(telemetryApi);
        }

        @Override
        public CompletionStage<BoltConnection> clear() {
            return this.connection.clear();
        }

        @Override
        public CompletionStage<Void> flush(ResponseHandler handler) {
            return this.connection.flush(handler);
        }

        @Override
        public CompletionStage<Void> forceClose(String reason) {
            return this.connection.forceClose(reason);
        }

        @Override
        public CompletionStage<Void> close() {
            this.closed.set(true);
            return this.connection.close();
        }

        @Override
        public BoltConnectionState state() {
            return this.connection.state();
        }

        @Override
        public CompletionStage<AuthData> authData() {
            return this.connection.authData();
        }

        @Override
        public String serverAgent() {
            return this.connection.serverAgent();
        }

        @Override
        public BoltServerAddress serverAddress() {
            return this.connection.serverAddress();
        }

        @Override
        public BoltProtocolVersion protocolVersion() {
            return this.connection.protocolVersion();
        }

        @Override
        public boolean telemetrySupported() {
            return this.connection.telemetrySupported();
        }
    }

    public static class RunRxResponseHandler
    implements ResponseHandler {
        final CompletableFuture<RxResultCursor> cursorFuture = new CompletableFuture();
        private final BoltConnection connection;
        private final Query query;
        private final Consumer<DatabaseBookmark> bookmarkConsumer;
        private final AtomicBoolean runFailed;
        private RunSummary runSummary;
        private Throwable error;
        private int ignoredCount;

        public RunRxResponseHandler(BoltConnection connection, Query query, Consumer<DatabaseBookmark> bookmarkConsumer, AtomicBoolean runFailed) {
            this.connection = connection;
            this.query = query;
            this.bookmarkConsumer = bookmarkConsumer;
            this.runFailed = runFailed;
        }

        @Override
        public void onError(Throwable throwable) {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (this.error == null) {
                this.error = throwable;
            } else if (this.error instanceof Neo4jException && !(throwable instanceof Neo4jException)) {
                throwable.addSuppressed(this.error);
                this.error = throwable;
            } else {
                this.error.addSuppressed(throwable);
            }
        }

        @Override
        public void onRunSummary(RunSummary summary) {
            this.runSummary = summary;
        }

        @Override
        public void onIgnored() {
            ++this.ignoredCount;
        }

        @Override
        public void onComplete() {
            if (this.runSummary != null || this.error != null) {
                if (this.error != null) {
                    this.runFailed.set(true);
                }
                this.cursorFuture.complete(new RxResultCursorImpl(this.connection, this.query, this.runSummary, this.error, () -> null, this.bookmarkConsumer, ignored -> {}, true, () -> null));
            } else {
                String message = this.ignoredCount > 0 ? "Run exchange contains ignored messages." : "Unexpected state during session run.";
                this.cursorFuture.completeExceptionally(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
            }
        }
    }
}

