/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionCallback;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.TransactionWork;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.AbstractQueryRunner;
import org.neo4j.driver.internal.DelegatingTransactionContext;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.InternalResult;
import org.neo4j.driver.internal.InternalTransaction;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.GqlStatusError;
import org.neo4j.driver.internal.bolt.api.TelemetryApi;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.internal.util.Futures;

public class InternalSession
extends AbstractQueryRunner
implements Session {
    private final NetworkSession session;

    public InternalSession(NetworkSession session) {
        this.session = session;
    }

    @Override
    public Result run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    @Override
    public Result run(String query, TransactionConfig config) {
        return this.run(query, Collections.emptyMap(), config);
    }

    @Override
    public Result run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Query(query, parameters), config);
    }

    @Override
    public Result run(Query query, TransactionConfig config) {
        ResultCursor cursor = Futures.blockingGet(this.session.runAsync(query, config), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in session"));
        BoltConnection connection = Futures.getNow(this.session.connectionAsync());
        return new InternalResult(connection, cursor);
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public void close() {
        Futures.blockingGet(this.session.closeAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the session"));
    }

    @Override
    public Transaction beginTransaction() {
        return this.beginTransaction(TransactionConfig.empty());
    }

    @Override
    public Transaction beginTransaction(TransactionConfig config) {
        return this.beginTransaction(config, null);
    }

    public Transaction beginTransaction(TransactionConfig config, String txType) {
        UnmanagedTransaction tx = Futures.blockingGet(this.session.beginTransactionAsync(config, txType, new ApiTelemetryWork(TelemetryApi.UNMANAGED_TRANSACTION)), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while starting a transaction"));
        return new InternalTransaction(tx);
    }

    @Override
    @Deprecated
    public <T> T readTransaction(TransactionWork<T> work) {
        return this.readTransaction(work, TransactionConfig.empty());
    }

    @Override
    @Deprecated
    public <T> T readTransaction(TransactionWork<T> work, TransactionConfig config) {
        return this.transaction(AccessMode.READ, work, config, TelemetryApi.MANAGED_TRANSACTION, true);
    }

    @Override
    public <T> T executeRead(TransactionCallback<T> callback, TransactionConfig config) {
        return this.execute(AccessMode.READ, callback, config, TelemetryApi.MANAGED_TRANSACTION, true);
    }

    @Override
    @Deprecated
    public <T> T writeTransaction(TransactionWork<T> work) {
        return this.writeTransaction(work, TransactionConfig.empty());
    }

    @Override
    @Deprecated
    public <T> T writeTransaction(TransactionWork<T> work, TransactionConfig config) {
        return this.transaction(AccessMode.WRITE, work, config, TelemetryApi.MANAGED_TRANSACTION, true);
    }

    @Override
    public <T> T executeWrite(TransactionCallback<T> callback, TransactionConfig config) {
        return this.execute(AccessMode.WRITE, callback, config, TelemetryApi.MANAGED_TRANSACTION, true);
    }

    @Override
    @Deprecated
    public Bookmark lastBookmark() {
        return InternalBookmark.from(this.session.lastBookmarks());
    }

    @Override
    public Set<Bookmark> lastBookmarks() {
        return this.session.lastBookmarks();
    }

    @Deprecated
    public void reset() {
        Futures.blockingGet(this.session.resetAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while resetting the session"));
    }

    <T> T execute(AccessMode accessMode, TransactionCallback<T> callback, TransactionConfig config, TelemetryApi telemetryApi, boolean flush) {
        return (T)this.transaction(accessMode, tx -> callback.execute(new DelegatingTransactionContext(tx)), config, telemetryApi, flush);
    }

    private <T> T transaction(AccessMode mode, TransactionWork<T> work, TransactionConfig config, TelemetryApi telemetryApi, boolean flush) {
        ApiTelemetryWork apiTelemetryWork = new ApiTelemetryWork(telemetryApi);
        return (T)this.session.retryLogic().retry(() -> {
            try (Transaction tx = this.beginTransaction(mode, config, apiTelemetryWork, flush);){
                Object result = work.execute(tx);
                if (result instanceof Result) {
                    String message = String.format("%s is not a valid return value, it should be consumed before producing a return value", Result.class.getName());
                    throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                }
                if (tx.isOpen()) {
                    tx.commit();
                }
                Object t = result;
                return t;
            }
        });
    }

    private Transaction beginTransaction(AccessMode mode, TransactionConfig config, ApiTelemetryWork apiTelemetryWork, boolean flush) {
        UnmanagedTransaction tx = Futures.blockingGet(this.session.beginTransactionAsync(mode, config, null, apiTelemetryWork, flush), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while starting a transaction"));
        return new InternalTransaction(tx);
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        BoltConnection connection = null;
        try {
            connection = Futures.getNow(this.session.connectionAsync());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (connection != null) {
            connection.forceClose(reason);
        }
    }
}

