/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.time.Clock;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BoltAgent;
import org.neo4j.driver.internal.DatabaseBookmark;
import org.neo4j.driver.internal.GqlNotificationConfig;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.messaging.v42.BoltProtocolV42;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.messaging.v44.BoltProtocolV44;
import org.neo4j.driver.internal.messaging.v5.BoltProtocolV5;
import org.neo4j.driver.internal.messaging.v51.BoltProtocolV51;
import org.neo4j.driver.internal.messaging.v52.BoltProtocolV52;
import org.neo4j.driver.internal.messaging.v53.BoltProtocolV53;
import org.neo4j.driver.internal.messaging.v54.BoltProtocolV54;
import org.neo4j.driver.internal.messaging.v55.BoltProtocolV55;
import org.neo4j.driver.internal.messaging.v56.BoltProtocolV56;
import org.neo4j.driver.internal.messaging.v57.BoltProtocolV57;
import org.neo4j.driver.internal.spi.Connection;

public interface BoltProtocol {
    public MessageFormat createMessageFormat();

    public void initializeChannel(String var1, BoltAgent var2, AuthToken var3, RoutingContext var4, ChannelPromise var5, GqlNotificationConfig var6, Clock var7);

    public void prepareToCloseChannel(Channel var1);

    public CompletionStage<Void> beginTransaction(Connection var1, Set<Bookmark> var2, TransactionConfig var3, String var4, GqlNotificationConfig var5, Logging var6, boolean var7);

    public CompletionStage<DatabaseBookmark> commitTransaction(Connection var1);

    public CompletionStage<Void> rollbackTransaction(Connection var1);

    public CompletionStage<Void> telemetry(Connection var1, Integer var2);

    public ResultCursorFactory runInAutoCommitTransaction(Connection var1, Query var2, Set<Bookmark> var3, Consumer<DatabaseBookmark> var4, TransactionConfig var5, long var6, GqlNotificationConfig var8, Logging var9);

    public ResultCursorFactory runInUnmanagedTransaction(Connection var1, Query var2, UnmanagedTransaction var3, long var4);

    public BoltProtocolVersion version();

    public static BoltProtocol forChannel(Channel channel) {
        return BoltProtocol.forVersion(ChannelAttributes.protocolVersion(channel));
    }

    public static BoltProtocol forVersion(BoltProtocolVersion version) {
        if (BoltProtocolV3.VERSION.equals(version)) {
            return BoltProtocolV3.INSTANCE;
        }
        if (BoltProtocolV4.VERSION.equals(version)) {
            return BoltProtocolV4.INSTANCE;
        }
        if (BoltProtocolV41.VERSION.equals(version)) {
            return BoltProtocolV41.INSTANCE;
        }
        if (BoltProtocolV42.VERSION.equals(version)) {
            return BoltProtocolV42.INSTANCE;
        }
        if (BoltProtocolV43.VERSION.equals(version)) {
            return BoltProtocolV43.INSTANCE;
        }
        if (BoltProtocolV44.VERSION.equals(version)) {
            return BoltProtocolV44.INSTANCE;
        }
        if (BoltProtocolV5.VERSION.equals(version)) {
            return BoltProtocolV5.INSTANCE;
        }
        if (BoltProtocolV51.VERSION.equals(version)) {
            return BoltProtocolV51.INSTANCE;
        }
        if (BoltProtocolV52.VERSION.equals(version)) {
            return BoltProtocolV52.INSTANCE;
        }
        if (BoltProtocolV53.VERSION.equals(version)) {
            return BoltProtocolV53.INSTANCE;
        }
        if (BoltProtocolV54.VERSION.equals(version)) {
            return BoltProtocolV54.INSTANCE;
        }
        if (BoltProtocolV55.VERSION.equals(version)) {
            return BoltProtocolV55.INSTANCE;
        }
        if (BoltProtocolV56.VERSION.equals(version)) {
            return BoltProtocolV56.INSTANCE;
        }
        if (BoltProtocolV57.VERSION.equals(version)) {
            return BoltProtocolV57.INSTANCE;
        }
        String message = "Unknown protocol version: " + version;
        throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
    }
}

