/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers.pulln;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.handlers.AbstractRecordStateResponseHandler;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.request.DiscardMessage;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.messaging.v55.BoltProtocolV55;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.summary.GqlStatusObject;
import org.neo4j.driver.summary.ResultSummary;

public class BasicPullResponseHandler
extends AbstractRecordStateResponseHandler
implements PullResponseHandler {
    private static final Runnable NO_OP_RUNNABLE = () -> {};
    private final Query query;
    protected final RunResponseHandler runResponseHandler;
    protected final MetadataExtractor metadataExtractor;
    protected final Connection connection;
    private final PullResponseCompletionListener completionListener;
    private final boolean syncSignals;
    private State state;
    private long toRequest;
    private BiConsumer<Record, Throwable> recordConsumer = null;
    private BiConsumer<ResultSummary, Throwable> summaryConsumer = null;

    public BasicPullResponseHandler(Query query, RunResponseHandler runResponseHandler, Connection connection, MetadataExtractor metadataExtractor, PullResponseCompletionListener completionListener) {
        this(query, runResponseHandler, connection, metadataExtractor, completionListener, false);
    }

    public BasicPullResponseHandler(Query query, RunResponseHandler runResponseHandler, Connection connection, MetadataExtractor metadataExtractor, PullResponseCompletionListener completionListener, boolean syncSignals) {
        this.query = Objects.requireNonNull(query);
        this.runResponseHandler = Objects.requireNonNull(runResponseHandler);
        this.metadataExtractor = Objects.requireNonNull(metadataExtractor);
        this.connection = Objects.requireNonNull(connection);
        this.completionListener = Objects.requireNonNull(completionListener);
        this.syncSignals = syncSignals;
        this.state = State.READY_STATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Map<String, Value> metadata) {
        State newState;
        BiConsumer<Record, Throwable> recordConsumer = null;
        BiConsumer<ResultSummary, Throwable> summaryConsumer = null;
        ResultSummary summary = null;
        Neo4jException exception = null;
        BasicPullResponseHandler basicPullResponseHandler = this;
        synchronized (basicPullResponseHandler) {
            this.assertRecordAndSummaryConsumerInstalled();
            this.state.onSuccess(this, metadata);
            newState = this.state;
            if (newState == State.SUCCEEDED_STATE) {
                this.completionListener.afterSuccess(metadata);
                try {
                    summary = this.extractResultSummary(metadata, this.generateGqlStatusObject(this.runResponseHandler.queryKeys().keys()));
                }
                catch (Neo4jException e) {
                    summary = this.extractResultSummary(Collections.emptyMap(), this.generateGqlStatusObject(this.runResponseHandler.queryKeys().keys()));
                    exception = e;
                }
                recordConsumer = this.recordConsumer;
                summaryConsumer = this.summaryConsumer;
                if (this.syncSignals) {
                    this.complete(summaryConsumer, recordConsumer, summary, exception);
                }
                this.dispose();
            } else if (newState == State.READY_STATE) {
                if (this.toRequest > 0L || this.toRequest == -1L) {
                    this.request(this.toRequest);
                    this.toRequest = 0L;
                }
                this.summaryConsumer.accept(null, null);
            }
        }
        if (!this.syncSignals && newState == State.SUCCEEDED_STATE) {
            this.complete(summaryConsumer, recordConsumer, summary, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable error) {
        BiConsumer<ResultSummary, Throwable> summaryConsumer;
        BiConsumer<Record, Throwable> recordConsumer;
        ResultSummary summary;
        BasicPullResponseHandler basicPullResponseHandler = this;
        synchronized (basicPullResponseHandler) {
            this.assertRecordAndSummaryConsumerInstalled();
            this.state.onFailure(this);
            this.completionListener.afterFailure(error);
            summary = this.extractResultSummary(Collections.emptyMap(), null);
            recordConsumer = this.recordConsumer;
            summaryConsumer = this.summaryConsumer;
            if (this.syncSignals) {
                this.complete(summaryConsumer, recordConsumer, summary, error);
            }
            this.dispose();
        }
        if (!this.syncSignals) {
            this.complete(summaryConsumer, recordConsumer, summary, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecord(Value[] fields) {
        State newState;
        InternalRecord record = null;
        BasicPullResponseHandler basicPullResponseHandler = this;
        synchronized (basicPullResponseHandler) {
            this.assertRecordAndSummaryConsumerInstalled();
            this.recordState = AbstractRecordStateResponseHandler.RecordState.HAD_RECORD;
            this.state.onRecord(this);
            newState = this.state;
            if (newState == State.STREAMING_STATE) {
                record = new InternalRecord(this.runResponseHandler.queryKeys(), fields);
                if (this.syncSignals) {
                    this.recordConsumer.accept(record, null);
                }
            }
        }
        if (!this.syncSignals && newState == State.STREAMING_STATE) {
            this.recordConsumer.accept(record, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long size) {
        Runnable postAction;
        BasicPullResponseHandler basicPullResponseHandler = this;
        synchronized (basicPullResponseHandler) {
            this.assertRecordAndSummaryConsumerInstalled();
            this.recordState = AbstractRecordStateResponseHandler.RecordState.NO_RECORD;
            postAction = this.state.request(this, size);
            if (this.syncSignals) {
                postAction.run();
            }
        }
        if (!this.syncSignals) {
            postAction.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        Runnable postAction;
        BasicPullResponseHandler basicPullResponseHandler = this;
        synchronized (basicPullResponseHandler) {
            this.assertRecordAndSummaryConsumerInstalled();
            postAction = this.state.cancel(this);
            if (this.syncSignals) {
                postAction.run();
            }
        }
        if (!this.syncSignals) {
            postAction.run();
        }
    }

    protected void writePull(long n) {
        this.connection.writeAndFlush(new PullMessage(n, this.runResponseHandler.queryId()), this);
    }

    protected void discardAll() {
        this.connection.writeAndFlush(DiscardMessage.newDiscardAllMessage(this.runResponseHandler.queryId()), this);
    }

    @Override
    public synchronized void installSummaryConsumer(BiConsumer<ResultSummary, Throwable> summaryConsumer) {
        if (this.summaryConsumer != null) {
            throw new IllegalStateException("Summary consumer already installed.");
        }
        this.summaryConsumer = summaryConsumer;
    }

    @Override
    public synchronized void installRecordConsumer(BiConsumer<Record, Throwable> recordConsumer) {
        if (this.recordConsumer != null) {
            throw new IllegalStateException("Record consumer already installed.");
        }
        this.recordConsumer = recordConsumer;
    }

    protected boolean isDone() {
        return this.state.equals((Object)State.SUCCEEDED_STATE) || this.state.equals((Object)State.FAILURE_STATE);
    }

    private ResultSummary extractResultSummary(Map<String, Value> metadata, GqlStatusObject gqlStatusObject) {
        long resultAvailableAfter = this.runResponseHandler.resultAvailableAfter();
        return this.metadataExtractor.extractSummary(this.query, this.connection, resultAvailableAfter, metadata, this.connection.protocol().version().compareTo(BoltProtocolV55.VERSION) < 0, gqlStatusObject);
    }

    private void addToRequest(long toAdd) {
        if (this.toRequest == -1L) {
            return;
        }
        if (toAdd == -1L) {
            this.toRequest = -1L;
            return;
        }
        if (toAdd <= 0L) {
            throw new IllegalArgumentException("Cannot request record amount that is less than or equal to 0. Request amount: " + toAdd);
        }
        this.toRequest += toAdd;
        if (this.toRequest <= 0L) {
            this.toRequest = Long.MAX_VALUE;
        }
    }

    private void assertRecordAndSummaryConsumerInstalled() {
        if (this.isDone()) {
            return;
        }
        if (this.recordConsumer == null || this.summaryConsumer == null) {
            throw new IllegalStateException(String.format("Access record stream without record consumer and/or summary consumer. Record consumer=%s, Summary consumer=%s", this.recordConsumer, this.summaryConsumer));
        }
    }

    private void complete(BiConsumer<ResultSummary, Throwable> summaryConsumer, BiConsumer<Record, Throwable> recordConsumer, ResultSummary summary, Throwable error) {
        summaryConsumer.accept(summary, error);
        recordConsumer.accept(null, error);
    }

    private void dispose() {
        this.recordConsumer = null;
        this.summaryConsumer = null;
    }

    protected State state() {
        return this.state;
    }

    protected void state(State state) {
        this.state = state;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum State {
        READY_STATE{

            @Override
            void onSuccess(BasicPullResponseHandler context, Map<String, Value> metadata) {
                context.state(SUCCEEDED_STATE);
            }

            @Override
            void onFailure(BasicPullResponseHandler context) {
                context.state(FAILURE_STATE);
            }

            @Override
            void onRecord(BasicPullResponseHandler context) {
                context.state(READY_STATE);
            }

            @Override
            Runnable request(BasicPullResponseHandler context, long n) {
                context.state(STREAMING_STATE);
                return () -> context.writePull(n);
            }

            @Override
            Runnable cancel(BasicPullResponseHandler context) {
                context.state(CANCELLED_STATE);
                return context::discardAll;
            }
        }
        ,
        STREAMING_STATE{

            @Override
            void onSuccess(BasicPullResponseHandler context, Map<String, Value> metadata) {
                if (metadata.getOrDefault("has_more", BooleanValue.FALSE).asBoolean()) {
                    context.state(READY_STATE);
                } else {
                    context.state(SUCCEEDED_STATE);
                }
            }

            @Override
            void onFailure(BasicPullResponseHandler context) {
                context.state(FAILURE_STATE);
            }

            @Override
            void onRecord(BasicPullResponseHandler context) {
                context.state(STREAMING_STATE);
            }

            @Override
            Runnable request(BasicPullResponseHandler context, long n) {
                context.state(STREAMING_STATE);
                context.addToRequest(n);
                return NO_OP_RUNNABLE;
            }

            @Override
            Runnable cancel(BasicPullResponseHandler context) {
                context.state(CANCELLED_STATE);
                return NO_OP_RUNNABLE;
            }
        }
        ,
        CANCELLED_STATE{

            @Override
            void onSuccess(BasicPullResponseHandler context, Map<String, Value> metadata) {
                if (metadata.getOrDefault("has_more", BooleanValue.FALSE).asBoolean()) {
                    context.state(CANCELLED_STATE);
                    context.discardAll();
                } else {
                    context.state(SUCCEEDED_STATE);
                }
            }

            @Override
            void onFailure(BasicPullResponseHandler context) {
                context.state(FAILURE_STATE);
            }

            @Override
            void onRecord(BasicPullResponseHandler context) {
                context.state(CANCELLED_STATE);
            }

            @Override
            Runnable request(BasicPullResponseHandler context, long n) {
                context.state(CANCELLED_STATE);
                return NO_OP_RUNNABLE;
            }

            @Override
            Runnable cancel(BasicPullResponseHandler context) {
                context.state(CANCELLED_STATE);
                return NO_OP_RUNNABLE;
            }
        }
        ,
        SUCCEEDED_STATE{

            @Override
            void onSuccess(BasicPullResponseHandler context, Map<String, Value> metadata) {
                context.state(SUCCEEDED_STATE);
            }

            @Override
            void onFailure(BasicPullResponseHandler context) {
                context.state(FAILURE_STATE);
            }

            @Override
            void onRecord(BasicPullResponseHandler context) {
                context.state(SUCCEEDED_STATE);
            }

            @Override
            Runnable request(BasicPullResponseHandler context, long n) {
                context.state(SUCCEEDED_STATE);
                return NO_OP_RUNNABLE;
            }

            @Override
            Runnable cancel(BasicPullResponseHandler context) {
                context.state(SUCCEEDED_STATE);
                return NO_OP_RUNNABLE;
            }
        }
        ,
        FAILURE_STATE{

            @Override
            void onSuccess(BasicPullResponseHandler context, Map<String, Value> metadata) {
                context.state(SUCCEEDED_STATE);
            }

            @Override
            void onFailure(BasicPullResponseHandler context) {
                context.state(FAILURE_STATE);
            }

            @Override
            void onRecord(BasicPullResponseHandler context) {
                context.state(FAILURE_STATE);
            }

            @Override
            Runnable request(BasicPullResponseHandler context, long n) {
                context.state(FAILURE_STATE);
                return NO_OP_RUNNABLE;
            }

            @Override
            Runnable cancel(BasicPullResponseHandler context) {
                context.state(FAILURE_STATE);
                return NO_OP_RUNNABLE;
            }
        };


        abstract void onSuccess(BasicPullResponseHandler var1, Map<String, Value> var2);

        abstract void onFailure(BasicPullResponseHandler var1);

        abstract void onRecord(BasicPullResponseHandler var1);

        abstract Runnable request(BasicPullResponseHandler var1, long var2);

        abstract Runnable cancel(BasicPullResponseHandler var1);
    }
}

