/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v3;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.time.Clock;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.UnsupportedFeatureException;
import org.neo4j.driver.internal.BoltAgent;
import org.neo4j.driver.internal.DatabaseBookmark;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cursor.AsyncResultCursorOnlyFactory;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.handlers.BeginTxResponseHandler;
import org.neo4j.driver.internal.handlers.CommitTxResponseHandler;
import org.neo4j.driver.internal.handlers.HelloResponseHandler;
import org.neo4j.driver.internal.handlers.NoOpResponseHandler;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullHandlers;
import org.neo4j.driver.internal.handlers.RollbackTxResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.BeginMessage;
import org.neo4j.driver.internal.messaging.request.CommitMessage;
import org.neo4j.driver.internal.messaging.request.GoodbyeMessage;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.messaging.request.MultiDatabaseUtil;
import org.neo4j.driver.internal.messaging.request.RollbackMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class BoltProtocolV3
implements BoltProtocol {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(3, 0);
    public static final BoltProtocol INSTANCE = new BoltProtocolV3();
    public static final MetadataExtractor METADATA_EXTRACTOR = new MetadataExtractor("t_first", "t_last");

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV3();
    }

    @Override
    public void initializeChannel(String userAgent, BoltAgent boltAgent, AuthToken authToken, RoutingContext routingContext, ChannelPromise channelInitializedPromise, NotificationConfig notificationConfig, Clock clock) {
        Neo4jException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            channelInitializedPromise.setFailure((Throwable)exception);
            return;
        }
        Channel channel = channelInitializedPromise.channel();
        HelloMessage message = routingContext.isServerRoutingEnabled() ? new HelloMessage(userAgent, null, ((InternalAuthToken)authToken).toMap(), routingContext.toMap(), this.includeDateTimeUtcPatchInHello(), notificationConfig) : new HelloMessage(userAgent, null, ((InternalAuthToken)authToken).toMap(), null, this.includeDateTimeUtcPatchInHello(), notificationConfig);
        HelloResponseHandler handler = new HelloResponseHandler(channelInitializedPromise, clock);
        ChannelAttributes.messageDispatcher(channel).enqueue(handler);
        channel.writeAndFlush((Object)message, channel.voidPromise());
    }

    @Override
    public void prepareToCloseChannel(Channel channel) {
        InboundMessageDispatcher messageDispatcher = ChannelAttributes.messageDispatcher(channel);
        GoodbyeMessage message = GoodbyeMessage.GOODBYE;
        messageDispatcher.enqueue(NoOpResponseHandler.INSTANCE);
        channel.writeAndFlush((Object)message, channel.voidPromise());
        messageDispatcher.prepareToCloseChannel();
    }

    @Override
    public CompletionStage<Void> beginTransaction(Connection connection, Set<Bookmark> bookmarks, TransactionConfig config, String txType, NotificationConfig notificationConfig, Logging logging) {
        Neo4jException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            return CompletableFuture.failedStage(exception);
        }
        try {
            this.verifyDatabaseNameBeforeTransaction(connection.databaseName());
        }
        catch (Exception error) {
            return Futures.failedFuture(error);
        }
        CompletableFuture<Void> beginTxFuture = new CompletableFuture<Void>();
        BeginMessage beginMessage = new BeginMessage(bookmarks, config, connection.databaseName(), connection.mode(), connection.impersonatedUser(), txType, notificationConfig, logging);
        connection.writeAndFlush(beginMessage, new BeginTxResponseHandler(beginTxFuture));
        return beginTxFuture;
    }

    @Override
    public CompletionStage<DatabaseBookmark> commitTransaction(Connection connection) {
        CompletableFuture<DatabaseBookmark> commitFuture = new CompletableFuture<DatabaseBookmark>();
        connection.writeAndFlush(CommitMessage.COMMIT, new CommitTxResponseHandler(commitFuture));
        return commitFuture;
    }

    @Override
    public CompletionStage<Void> rollbackTransaction(Connection connection) {
        CompletableFuture<Void> rollbackFuture = new CompletableFuture<Void>();
        connection.writeAndFlush(RollbackMessage.ROLLBACK, new RollbackTxResponseHandler(rollbackFuture));
        return rollbackFuture;
    }

    @Override
    public ResultCursorFactory runInAutoCommitTransaction(Connection connection, Query query, Set<Bookmark> bookmarks, Consumer<DatabaseBookmark> bookmarkConsumer, TransactionConfig config, long fetchSize, NotificationConfig notificationConfig, Logging logging) {
        Neo4jException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            throw exception;
        }
        this.verifyDatabaseNameBeforeTransaction(connection.databaseName());
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.autoCommitTxRunMessage(query, config, connection.databaseName(), connection.mode(), bookmarks, connection.impersonatedUser(), notificationConfig, logging);
        return this.buildResultCursorFactory(connection, query, bookmarkConsumer, null, runMessage, fetchSize);
    }

    @Override
    public ResultCursorFactory runInUnmanagedTransaction(Connection connection, Query query, UnmanagedTransaction tx, long fetchSize) {
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.unmanagedTxRunMessage(query);
        return this.buildResultCursorFactory(connection, query, ignored -> {}, tx, runMessage, fetchSize);
    }

    protected ResultCursorFactory buildResultCursorFactory(Connection connection, Query query, Consumer<DatabaseBookmark> bookmarkConsumer, UnmanagedTransaction tx, RunWithMetadataMessage runMessage, long ignored) {
        CompletableFuture<Void> runFuture = new CompletableFuture<Void>();
        RunResponseHandler runHandler = new RunResponseHandler(runFuture, METADATA_EXTRACTOR, connection, tx);
        PullAllResponseHandler pullHandler = PullHandlers.newBoltV3PullAllHandler(query, runHandler, connection, bookmarkConsumer, tx);
        return new AsyncResultCursorOnlyFactory(connection, runMessage, runHandler, runFuture, pullHandler);
    }

    protected void verifyDatabaseNameBeforeTransaction(DatabaseName databaseName) {
        MultiDatabaseUtil.assertEmptyDatabaseName(databaseName, this.version());
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }

    protected boolean includeDateTimeUtcPatchInHello() {
        return false;
    }

    protected Neo4jException verifyNotificationConfigSupported(NotificationConfig notificationConfig) {
        UnsupportedFeatureException exception = null;
        if (notificationConfig != null && !notificationConfig.equals(NotificationConfig.defaultConfig())) {
            exception = new UnsupportedFeatureException(String.format("Notification configuration is not supported on Bolt %s", this.version().toString()));
        }
        return exception;
    }
}

