/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.AsyncTransactionCallback;
import org.neo4j.driver.async.AsyncTransactionWork;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.AsyncAbstractQueryRunner;
import org.neo4j.driver.internal.async.DelegatingAsyncTransactionContext;
import org.neo4j.driver.internal.async.InternalAsyncTransaction;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.util.Futures;

public class InternalAsyncSession
extends AsyncAbstractQueryRunner
implements AsyncSession {
    private final NetworkSession session;

    public InternalAsyncSession(NetworkSession session) {
        this.session = session;
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(Query query) {
        return this.runAsync(query, TransactionConfig.empty());
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(String query, TransactionConfig config) {
        return this.runAsync(query, Collections.emptyMap(), config);
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.runAsync(new Query(query, parameters), config);
    }

    @Override
    public CompletionStage<ResultCursor> runAsync(Query query, TransactionConfig config) {
        return this.session.runAsync(query, config);
    }

    @Override
    public CompletionStage<Void> closeAsync() {
        return this.session.closeAsync();
    }

    @Override
    public CompletionStage<AsyncTransaction> beginTransactionAsync() {
        return this.beginTransactionAsync(TransactionConfig.empty());
    }

    @Override
    public CompletionStage<AsyncTransaction> beginTransactionAsync(TransactionConfig config) {
        return this.session.beginTransactionAsync(config).thenApply(InternalAsyncTransaction::new);
    }

    @Override
    @Deprecated
    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.readTransactionAsync(work, TransactionConfig.empty());
    }

    @Override
    @Deprecated
    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.transactionAsync(AccessMode.READ, work, config);
    }

    @Override
    public <T> CompletionStage<T> executeReadAsync(AsyncTransactionCallback<CompletionStage<T>> callback, TransactionConfig config) {
        return this.readTransactionAsync(tx -> (CompletionStage)callback.execute(new DelegatingAsyncTransactionContext(tx)), config);
    }

    @Override
    @Deprecated
    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.writeTransactionAsync(work, TransactionConfig.empty());
    }

    @Override
    @Deprecated
    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.transactionAsync(AccessMode.WRITE, work, config);
    }

    @Override
    public <T> CompletionStage<T> executeWriteAsync(AsyncTransactionCallback<CompletionStage<T>> callback, TransactionConfig config) {
        return this.writeTransactionAsync(tx -> (CompletionStage)callback.execute(new DelegatingAsyncTransactionContext(tx)), config);
    }

    @Override
    @Deprecated
    public Bookmark lastBookmark() {
        return InternalBookmark.from(this.session.lastBookmarks());
    }

    @Override
    public Set<Bookmark> lastBookmarks() {
        return new HashSet<Bookmark>(this.session.lastBookmarks());
    }

    private <T> CompletionStage<T> transactionAsync(AccessMode mode, AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.session.retryLogic().retryAsync(() -> {
            CompletableFuture resultFuture = new CompletableFuture();
            CompletionStage<UnmanagedTransaction> txFuture = this.session.beginTransactionAsync(mode, config);
            txFuture.whenComplete((tx, completionError) -> {
                Throwable error = Futures.completionExceptionCause(completionError);
                if (error != null) {
                    resultFuture.completeExceptionally(error);
                } else {
                    this.executeWork(resultFuture, (UnmanagedTransaction)tx, work);
                }
            });
            return resultFuture;
        });
    }

    private <T> void executeWork(CompletableFuture<T> resultFuture, UnmanagedTransaction tx, AsyncTransactionWork<CompletionStage<T>> work) {
        CompletionStage<Object> workFuture = this.safeExecuteWork(tx, work);
        workFuture.whenComplete((result, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                this.closeTxAfterFailedTransactionWork(tx, resultFuture, error);
            } else if (result instanceof ResultCursor) {
                error = new ClientException(String.format("%s is not a valid return value, it should be consumed before producing a return value", ResultCursor.class.getName()));
                this.closeTxAfterFailedTransactionWork(tx, resultFuture, error);
            } else {
                this.closeTxAfterSucceededTransactionWork(tx, resultFuture, result);
            }
        });
    }

    private <T> CompletionStage<T> safeExecuteWork(UnmanagedTransaction tx, AsyncTransactionWork<CompletionStage<T>> work) {
        try {
            CompletionStage<T> result = work.execute(new InternalAsyncTransaction(tx));
            return result == null ? Futures.completedWithNull() : result;
        }
        catch (Throwable workError) {
            return Futures.failedFuture(workError);
        }
    }

    private <T> void closeTxAfterFailedTransactionWork(UnmanagedTransaction tx, CompletableFuture<T> resultFuture, Throwable error) {
        tx.closeAsync().whenComplete((ignored, rollbackError) -> {
            if (rollbackError != null) {
                error.addSuppressed((Throwable)rollbackError);
            }
            resultFuture.completeExceptionally(error);
        });
    }

    private <T> void closeTxAfterSucceededTransactionWork(UnmanagedTransaction tx, CompletableFuture<T> resultFuture, T result) {
        tx.closeAsync(true).whenComplete((ignored, completionError) -> {
            Throwable commitError = Futures.completionExceptionCause(completionError);
            if (commitError != null) {
                resultFuture.completeExceptionally(commitError);
            } else {
                resultFuture.complete(result);
            }
        });
    }
}

