/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Optional;
import java.util.function.Function;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalNotificationCategory;
import org.neo4j.driver.internal.InternalNotificationSeverity;
import org.neo4j.driver.internal.summary.InternalInputPosition;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.driver.summary.InputPosition;
import org.neo4j.driver.summary.Notification;

public class InternalNotification
implements Notification {
    public static final Function<Value, Notification> VALUE_TO_NOTIFICATION = value -> {
        String code = value.get("code").asString();
        String title = value.get("title").asString();
        String description = value.get("description").asString();
        String rawSeverityLevel = value.containsKey("severity") ? value.get("severity").asString() : null;
        NotificationSeverity severityLevel = InternalNotificationSeverity.valueOf(rawSeverityLevel).orElse(null);
        String rawCategory = value.containsKey("category") ? value.get("category").asString() : null;
        NotificationCategory category = InternalNotificationCategory.valueOf(rawCategory).orElse(null);
        Value posValue = value.get("position");
        InternalInputPosition position = null;
        if (posValue != NullValue.NULL) {
            position = new InternalInputPosition(posValue.get("offset").asInt(), posValue.get("line").asInt(), posValue.get("column").asInt());
        }
        return new InternalNotification(code, title, description, severityLevel, rawSeverityLevel, category, rawCategory, position);
    };
    private final String code;
    private final String title;
    private final String description;
    private final NotificationSeverity severityLevel;
    private final String rawSeverityLevel;
    private final NotificationCategory category;
    private final String rawCategory;
    private final InputPosition position;

    public InternalNotification(String code, String title, String description, NotificationSeverity severityLevel, String rawSeverityLevel, NotificationCategory category, String rawCategory, InputPosition position) {
        this.code = code;
        this.title = title;
        this.description = description;
        this.severityLevel = severityLevel;
        this.rawSeverityLevel = rawSeverityLevel;
        this.category = category;
        this.rawCategory = rawCategory;
        this.position = position;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public InputPosition position() {
        return this.position;
    }

    @Override
    public Optional<NotificationSeverity> severityLevel() {
        return Optional.ofNullable(this.severityLevel);
    }

    @Override
    public Optional<String> rawSeverityLevel() {
        return Optional.ofNullable(this.rawSeverityLevel);
    }

    @Override
    public Optional<NotificationCategory> category() {
        return Optional.ofNullable(this.category);
    }

    @Override
    public Optional<String> rawCategory() {
        return Optional.ofNullable(this.rawCategory);
    }

    public String toString() {
        String info = "code=" + this.code + ", title=" + this.title + ", description=" + this.description + ", severityLevel=" + this.severityLevel + ", rawSeverityLevel=" + this.rawSeverityLevel + ", category=" + this.category + ", rawCategory=" + this.rawCategory;
        return this.position == null ? info : info + ", position={" + this.position + "}";
    }
}

