/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.net.URI;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.SecuritySettings;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlan;

public final class GraphDatabase {
    private GraphDatabase() {
    }

    public static Driver driver(String uri) {
        return GraphDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri) {
        return GraphDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri, Config config) {
        return GraphDatabase.driver(uri, AuthTokens.none(), config);
    }

    public static Driver driver(String uri, Config config) {
        return GraphDatabase.driver(URI.create(uri), config);
    }

    public static Driver driver(String uri, AuthToken authToken) {
        return GraphDatabase.driver(uri, authToken, Config.defaultConfig());
    }

    public static Driver driver(URI uri, AuthToken authToken) {
        return GraphDatabase.driver(uri, authToken, Config.defaultConfig());
    }

    public static Driver driver(String uri, AuthToken authToken, Config config) {
        return GraphDatabase.driver(URI.create(uri), authToken, config);
    }

    public static Driver driver(URI uri, AuthToken authToken, Config config) {
        return GraphDatabase.driver(uri, authToken, config, new DriverFactory());
    }

    static Driver driver(URI uri, AuthToken authToken, Config config, DriverFactory driverFactory) {
        config = GraphDatabase.getOrDefault(config);
        RoutingSettings routingSettings = config.routingSettings();
        RetrySettings retrySettings = config.retrySettings();
        SecuritySettings securitySettings = config.securitySettings();
        SecurityPlan securityPlan = securitySettings.createSecurityPlan(uri.getScheme());
        return driverFactory.newInstance(uri, authToken, routingSettings, retrySettings, config, securityPlan);
    }

    private static Config getOrDefault(Config config) {
        return config != null ? config : Config.defaultConfig();
    }
}

