/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.reactive.AbstractReactiveSession;
import org.neo4j.driver.internal.reactive.BaseReactiveQueryRunner;
import org.neo4j.driver.internal.reactive.DelegatingReactiveTransactionContext;
import org.neo4j.driver.internal.reactive.InternalReactiveResult;
import org.neo4j.driver.internal.reactive.InternalReactiveTransaction;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.ReactiveResult;
import org.neo4j.driver.reactive.ReactiveSession;
import org.neo4j.driver.reactive.ReactiveTransaction;
import org.neo4j.driver.reactive.ReactiveTransactionCallback;
import org.reactivestreams.Publisher;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Mono;

public class InternalReactiveSession
extends AbstractReactiveSession<ReactiveTransaction>
implements ReactiveSession,
BaseReactiveQueryRunner {
    public InternalReactiveSession(NetworkSession session) {
        super(session);
    }

    @Override
    ReactiveTransaction createTransaction(UnmanagedTransaction unmanagedTransaction) {
        return new InternalReactiveTransaction(unmanagedTransaction);
    }

    @Override
    Publisher<Void> closeTransaction(ReactiveTransaction transaction, boolean commit) {
        return ((InternalReactiveTransaction)transaction).close(commit);
    }

    @Override
    public Flow.Publisher<ReactiveTransaction> beginTransaction(TransactionConfig config) {
        return this.beginTransaction(config, null);
    }

    public Flow.Publisher<ReactiveTransaction> beginTransaction(TransactionConfig config, String txType) {
        return JdkFlowAdapter.publisherToFlowPublisher(this.doBeginTransaction(config, txType));
    }

    @Override
    public <T> Flow.Publisher<T> executeRead(ReactiveTransactionCallback<? extends Flow.Publisher<T>> callback, TransactionConfig config) {
        return JdkFlowAdapter.publisherToFlowPublisher(this.runTransaction(AccessMode.READ, tx -> JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)((Flow.Publisher)callback.execute(new DelegatingReactiveTransactionContext((ReactiveTransaction)tx)))), config));
    }

    @Override
    public <T> Flow.Publisher<T> executeWrite(ReactiveTransactionCallback<? extends Flow.Publisher<T>> callback, TransactionConfig config) {
        return JdkFlowAdapter.publisherToFlowPublisher(this.runTransaction(AccessMode.WRITE, tx -> JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)((Flow.Publisher)callback.execute(new DelegatingReactiveTransactionContext((ReactiveTransaction)tx)))), config));
    }

    @Override
    public Flow.Publisher<ReactiveResult> run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    @Override
    public Flow.Publisher<ReactiveResult> run(Query query, TransactionConfig config) {
        CompletionStage<Object> cursorStage;
        try {
            cursorStage = this.session.runRx(query, config);
        }
        catch (Throwable t) {
            cursorStage = Futures.failedFuture(t);
        }
        return JdkFlowAdapter.publisherToFlowPublisher((Publisher)Mono.fromCompletionStage(cursorStage).onErrorResume(error -> Mono.fromCompletionStage(this.session.releaseConnectionAsync()).onErrorMap(releaseError -> Futures.combineErrors(error, releaseError)).then(Mono.error((Throwable)error))).flatMap(cursor -> {
            Throwable runError = cursor.getRunError();
            Mono publisher = runError != null ? Mono.fromCompletionStage(this.session.releaseConnectionAsync()).onErrorMap(releaseError -> Futures.combineErrors(runError, releaseError)).then(Mono.error((Throwable)runError)) : Mono.just((Object)cursor);
            return publisher;
        }).map(InternalReactiveResult::new));
    }

    @Override
    public Set<Bookmark> lastBookmarks() {
        return new HashSet<Bookmark>(this.session.lastBookmarks());
    }

    @Override
    public <T> Flow.Publisher<T> close() {
        return JdkFlowAdapter.publisherToFlowPublisher(this.doClose());
    }
}

