/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueryKeys {
    private static final QueryKeys EMPTY = new QueryKeys(Collections.emptyList(), Collections.emptyMap());
    private final List<String> keys;
    private final Map<String, Integer> keyIndex;

    public QueryKeys(int size) {
        this(new ArrayList<String>(size), new HashMap<String, Integer>(size));
    }

    public QueryKeys(List<String> keys) {
        this.keys = keys;
        HashMap<String, Integer> keyIndex = new HashMap<String, Integer>(keys.size());
        int i = 0;
        for (String key : keys) {
            keyIndex.put(key, i++);
        }
        this.keyIndex = keyIndex;
    }

    public QueryKeys(List<String> keys, Map<String, Integer> keyIndex) {
        this.keys = keys;
        this.keyIndex = keyIndex;
    }

    public void add(String key) {
        int index = this.keys.size();
        this.keys.add(key);
        this.keyIndex.put(key, index);
    }

    public List<String> keys() {
        return this.keys;
    }

    public Map<String, Integer> keyIndex() {
        return this.keyIndex;
    }

    public static QueryKeys empty() {
        return EMPTY;
    }

    public int indexOf(String key) {
        return this.keyIndex.getOrDefault(key, -1);
    }

    public boolean contains(String key) {
        return this.keyIndex.containsKey(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryKeys queryKeys = (QueryKeys)o;
        return this.keys.equals(queryKeys.keys) && this.keyIndex.equals(queryKeys.keyIndex);
    }

    public int hashCode() {
        return Objects.hash(this.keys, this.keyIndex);
    }
}

