/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.util.Futures;
import org.reactivestreams.Publisher;

public class RxUtils {
    public static <T> Publisher<T> createEmptyPublisher(Supplier<CompletionStage<Void>> supplier) {
        return Mono.create(sink -> ((CompletionStage)supplier.get()).whenComplete((ignore, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                sink.error(error);
            } else {
                sink.success();
            }
        }));
    }

    public static <T> Publisher<T> createMono(Supplier<CompletionStage<T>> supplier) {
        return Mono.create(sink -> ((CompletionStage)supplier.get()).whenComplete((item, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (item != null) {
                sink.success(item);
            }
            if (error != null) {
                sink.error(error);
            } else {
                sink.success();
            }
        }));
    }
}

