/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Config;
import org.neo4j.driver.Logging;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.DefaultBookmarkHolder;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.async.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.ConnectionProvider;

public class SessionFactoryImpl
implements SessionFactory {
    private final ConnectionProvider connectionProvider;
    private final RetryLogic retryLogic;
    private final Logging logging;
    private final boolean leakedSessionsLoggingEnabled;
    private final long defaultFetchSize;

    SessionFactoryImpl(ConnectionProvider connectionProvider, RetryLogic retryLogic, Config config) {
        this.connectionProvider = connectionProvider;
        this.leakedSessionsLoggingEnabled = config.logLeakedSessions();
        this.retryLogic = retryLogic;
        this.logging = config.logging();
        this.defaultFetchSize = config.fetchSize();
    }

    @Override
    public NetworkSession newInstance(SessionConfig sessionConfig) {
        DefaultBookmarkHolder bookmarkHolder = new DefaultBookmarkHolder(InternalBookmark.from(sessionConfig.bookmarks()));
        return this.createSession(this.connectionProvider, this.retryLogic, this.parseDatabaseName(sessionConfig), sessionConfig.defaultAccessMode(), bookmarkHolder, this.parseFetchSize(sessionConfig), this.logging);
    }

    private long parseFetchSize(SessionConfig sessionConfig) {
        return sessionConfig.fetchSize().orElse(this.defaultFetchSize);
    }

    private DatabaseName parseDatabaseName(SessionConfig sessionConfig) {
        return sessionConfig.database().flatMap(name -> Optional.of(DatabaseNameUtil.database(name))).orElse(DatabaseNameUtil.defaultDatabase());
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.connectionProvider.verifyConnectivity();
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionProvider.close();
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    private NetworkSession createSession(ConnectionProvider connectionProvider, RetryLogic retryLogic, DatabaseName databaseName, AccessMode mode, BookmarkHolder bookmarkHolder, long fetchSize, Logging logging) {
        return this.leakedSessionsLoggingEnabled ? new LeakLoggingNetworkSession(connectionProvider, retryLogic, databaseName, mode, bookmarkHolder, fetchSize, logging) : new NetworkSession(connectionProvider, retryLogic, databaseName, mode, bookmarkHolder, fetchSize, logging);
    }
}

