/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.scheduler;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.internal.TimedExecutorService;
import io.micrometer.core.instrument.search.Search;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.neo4j.driver.internal.shaded.reactor.core.Disposable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.scheduler.Scheduler;

final class SchedulerMetricDecorator
implements BiFunction<Scheduler, ScheduledExecutorService, ScheduledExecutorService>,
Disposable {
    static final String TAG_SCHEDULER_ID = "org.neo4j.driver.internal.shaded.reactor.scheduler.id";
    static final String METRICS_DECORATOR_KEY = "org.neo4j.driver.internal.shaded.reactor.metrics.decorator";
    final WeakHashMap<Scheduler, String> seenSchedulers = new WeakHashMap();
    final Map<String, AtomicInteger> schedulerDifferentiator = new HashMap<String, AtomicInteger>();
    final WeakHashMap<Scheduler, AtomicInteger> executorDifferentiator = new WeakHashMap();

    SchedulerMetricDecorator() {
    }

    @Override
    public synchronized ScheduledExecutorService apply(Scheduler scheduler, ScheduledExecutorService service) {
        String schedulerName = Scannable.from(scheduler).scanOrDefault(Scannable.Attr.NAME, scheduler.getClass().getName());
        String schedulerId = this.seenSchedulers.computeIfAbsent(scheduler, s -> {
            int schedulerDifferentiator = this.schedulerDifferentiator.computeIfAbsent(schedulerName, k -> new AtomicInteger(0)).getAndIncrement();
            return schedulerDifferentiator == 0 ? schedulerName : schedulerName + "#" + schedulerDifferentiator;
        });
        String executorId = schedulerId + "-" + this.executorDifferentiator.computeIfAbsent(scheduler, key -> new AtomicInteger(0)).getAndIncrement();
        Tags tags = Tags.of((String)TAG_SCHEDULER_ID, (String)schedulerId);
        ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)service, (String)executorId, (Iterable)tags);
        return new TimedScheduledExecutorService((MeterRegistry)Metrics.globalRegistry, service, executorId, (Iterable<Tag>)tags);
    }

    @Override
    public void dispose() {
        Search.in((MeterRegistry)Metrics.globalRegistry).tagKeys(new String[]{TAG_SCHEDULER_ID}).meters().forEach(arg_0 -> ((CompositeMeterRegistry)Metrics.globalRegistry).remove(arg_0));
        this.seenSchedulers.clear();
        this.schedulerDifferentiator.clear();
        this.executorDifferentiator.clear();
    }

    static final class TimedScheduledExecutorService
    extends TimedExecutorService
    implements ScheduledExecutorService {
        final ScheduledExecutorService delegate;

        public TimedScheduledExecutorService(MeterRegistry registry, ScheduledExecutorService delegate, String executorServiceName, Iterable<Tag> tags) {
            super(registry, (ExecutorService)delegate, executorServiceName, tags);
            this.delegate = delegate;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.delegate.schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.delegate.schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }
}

