/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers.pulln;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.neo4j.driver.Record;
import org.neo4j.driver.Statement;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.summary.ResultSummary;

public class AutoPullResponseHandler
extends BasicPullResponseHandler
implements PullAllResponseHandler {
    private static final Queue<Record> UNINITIALIZED_RECORDS = Iterables.emptyQueue();
    private final long fetchSize;
    private Queue<Record> records = UNINITIALIZED_RECORDS;
    private ResultSummary summary;
    private Throwable failure;
    private CompletableFuture<Record> recordFuture;
    private CompletableFuture<ResultSummary> summaryFuture;

    public AutoPullResponseHandler(Statement statement, RunResponseHandler runResponseHandler, Connection connection, MetadataExtractor metadataExtractor, PullResponseCompletionListener completionListener, long fetchSize) {
        super(statement, runResponseHandler, connection, metadataExtractor, completionListener);
        this.fetchSize = fetchSize;
        this.installRecordAndSummaryConsumers();
    }

    private void installRecordAndSummaryConsumers() {
        this.installRecordConsumer((record, error) -> {
            if (record != null) {
                this.enqueueRecord((Record)record);
                this.completeRecordFuture((Record)record);
            }
            if (record == null && error == null) {
                this.completeRecordFuture(null);
            }
        });
        this.installSummaryConsumer((summary, error) -> {
            if (error != null) {
                this.handleFailure((Throwable)error);
            }
            if (summary != null) {
                this.summary = summary;
                this.completeSummaryFuture((ResultSummary)summary);
            }
            if (error == null && summary == null) {
                this.request(this.fetchSize);
            }
        });
    }

    private void handleFailure(Throwable error) {
        if (!this.failRecordFuture(error) && !this.failSummaryFuture(error)) {
            this.failure = error;
        }
    }

    @Override
    public synchronized CompletionStage<Record> peekAsync() {
        Record record = this.records.peek();
        if (record == null) {
            if (this.isDone()) {
                return this.completedWithValueIfNoFailure(null);
            }
            if (this.recordFuture == null) {
                this.recordFuture = new CompletableFuture();
            }
            return this.recordFuture;
        }
        return CompletableFuture.completedFuture(record);
    }

    @Override
    public synchronized CompletionStage<Record> nextAsync() {
        return this.peekAsync().thenApply(ignore -> this.dequeueRecord());
    }

    @Override
    public synchronized CompletionStage<ResultSummary> consumeAsync() {
        this.records.clear();
        if (this.isDone()) {
            return this.completedWithValueIfNoFailure(this.summary);
        }
        this.cancel();
        if (this.summaryFuture == null) {
            this.summaryFuture = new CompletableFuture();
        }
        return this.summaryFuture;
    }

    @Override
    public synchronized <T> CompletionStage<List<T>> listAsync(Function<Record, T> mapFunction) {
        return this.pullAllAsync().thenApply(summary -> this.recordsAsList(mapFunction));
    }

    @Override
    public synchronized CompletionStage<Throwable> pullAllFailureAsync() {
        return this.pullAllAsync().handle((ignore, error) -> error);
    }

    @Override
    public void prePopulateRecords() {
        this.request(this.fetchSize);
    }

    private synchronized CompletionStage<ResultSummary> pullAllAsync() {
        if (this.isDone()) {
            return this.completedWithValueIfNoFailure(this.summary);
        }
        this.request(-1L);
        if (this.summaryFuture == null) {
            this.summaryFuture = new CompletableFuture();
        }
        return this.summaryFuture;
    }

    private void enqueueRecord(Record record) {
        if (this.records == UNINITIALIZED_RECORDS) {
            this.records = new ArrayDeque<Record>();
        }
        this.records.add(record);
    }

    private Record dequeueRecord() {
        return this.records.poll();
    }

    private <T> List<T> recordsAsList(Function<Record, T> mapFunction) {
        if (!this.isDone()) {
            throw new IllegalStateException("Can't get records as list because SUCCESS or FAILURE did not arrive");
        }
        ArrayList<T> result = new ArrayList<T>(this.records.size());
        while (!this.records.isEmpty()) {
            Record record = this.records.poll();
            result.add(mapFunction.apply(record));
        }
        return result;
    }

    private Throwable extractFailure() {
        if (this.failure == null) {
            throw new IllegalStateException("Can't extract failure because it does not exist");
        }
        Throwable error = this.failure;
        this.failure = null;
        return error;
    }

    private void completeRecordFuture(Record record) {
        if (this.recordFuture != null) {
            CompletableFuture<Record> future = this.recordFuture;
            this.recordFuture = null;
            future.complete(record);
        }
    }

    private void completeSummaryFuture(ResultSummary summary) {
        if (this.summaryFuture != null) {
            CompletableFuture<ResultSummary> future = this.summaryFuture;
            this.summaryFuture = null;
            future.complete(summary);
        }
    }

    private boolean failRecordFuture(Throwable error) {
        if (this.recordFuture != null) {
            CompletableFuture<Record> future = this.recordFuture;
            this.recordFuture = null;
            future.completeExceptionally(error);
            return true;
        }
        return false;
    }

    private boolean failSummaryFuture(Throwable error) {
        if (this.summaryFuture != null) {
            CompletableFuture<ResultSummary> future = this.summaryFuture;
            this.summaryFuture = null;
            future.completeExceptionally(error);
            return true;
        }
        return false;
    }

    private <T> CompletionStage<T> completedWithValueIfNoFailure(T value) {
        if (this.failure != null) {
            return Futures.failedFuture(this.extractFailure());
        }
        if (value == null) {
            return Futures.completedWithNull();
        }
        return CompletableFuture.completedFuture(value);
    }
}

