/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Disposable;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.ConnectableFlux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxHide;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Publisher;

final class ConnectableLiftFuseable<I, O>
extends ConnectableFlux<O>
implements Scannable,
Fuseable {
    final BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;
    final ConnectableFlux<I> source;

    ConnectableLiftFuseable(ConnectableFlux<I> p, BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        this.source = Objects.requireNonNull(p, "source");
        this.lifter = lifter;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public void connect(Consumer<? super Disposable> cancelSupport) {
        this.source.connect();
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return this.source.getPrefetch();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super O> actual) {
        CoreSubscriber<? super I> input = this.lifter.apply(this.source, actual);
        Objects.requireNonNull(input, "Lifted subscriber MUST NOT be null");
        if (actual instanceof Fuseable.QueueSubscription && !(input instanceof Fuseable.QueueSubscription)) {
            input = new FluxHide.SuppressFuseableSubscriber<I>(input);
        }
        this.source.subscribe(input);
    }
}

