/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Statement;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.messaging.request.MessageWithMetadata;
import org.neo4j.driver.internal.messaging.request.TransactionMetadataBuilder;

public class RunWithMetadataMessage
extends MessageWithMetadata {
    public static final byte SIGNATURE = 16;
    private final String statement;
    private final Map<String, Value> parameters;

    public static RunWithMetadataMessage autoCommitTxRunMessage(Statement statement, TransactionConfig config, String databaseName, AccessMode mode, InternalBookmark bookmark) {
        return RunWithMetadataMessage.autoCommitTxRunMessage(statement, config.timeout(), config.metadata(), databaseName, mode, bookmark);
    }

    public static RunWithMetadataMessage autoCommitTxRunMessage(Statement statement, Duration txTimeout, Map<String, Value> txMetadata, String databaseName, AccessMode mode, InternalBookmark bookmark) {
        Map<String, Value> metadata = TransactionMetadataBuilder.buildMetadata(txTimeout, txMetadata, databaseName, mode, bookmark);
        return new RunWithMetadataMessage(statement.text(), statement.parameters().asMap(Values.ofValue()), metadata);
    }

    public static RunWithMetadataMessage explicitTxRunMessage(Statement statement) {
        return new RunWithMetadataMessage(statement.text(), statement.parameters().asMap(Values.ofValue()), Collections.emptyMap());
    }

    private RunWithMetadataMessage(String statement, Map<String, Value> parameters, Map<String, Value> metadata) {
        super(metadata);
        this.statement = statement;
        this.parameters = parameters;
    }

    public String statement() {
        return this.statement;
    }

    public Map<String, Value> parameters() {
        return this.parameters;
    }

    @Override
    public byte signature() {
        return 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunWithMetadataMessage that = (RunWithMetadataMessage)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.metadata(), that.metadata());
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.parameters, this.metadata());
    }

    public String toString() {
        return "RUN \"" + this.statement + "\" " + this.parameters + " " + this.metadata();
    }
}

