/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Futures;

public class LeakLoggingNetworkSession
extends NetworkSession {
    private final String stackTrace = LeakLoggingNetworkSession.captureStackTrace();

    public LeakLoggingNetworkSession(ConnectionProvider connectionProvider, RetryLogic retryLogic, String databaseName, AccessMode mode, BookmarkHolder bookmarkHolder, Logging logging) {
        super(connectionProvider, retryLogic, databaseName, mode, bookmarkHolder, logging);
    }

    protected void finalize() throws Throwable {
        this.logLeakIfNeeded();
        super.finalize();
    }

    private void logLeakIfNeeded() {
        Boolean isOpen = Futures.blockingGet(this.currentConnectionIsOpen());
        if (isOpen.booleanValue()) {
            this.logger.error("Neo4j Session object leaked, please ensure that your application fully consumes results in Sessions or explicitly calls `close` on Sessions before disposing of the objects.\nSession was create at:\n" + this.stackTrace, null);
        }
    }

    private static String captureStackTrace() {
        StackTraceElement[] elements;
        StringBuilder result = new StringBuilder();
        for (StackTraceElement element : elements = Thread.currentThread().getStackTrace()) {
            result.append("\t").append(element).append(System.lineSeparator());
        }
        return result.toString();
    }
}

