/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v4;

import org.neo4j.driver.Statement;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.async.ExplicitTransaction;
import org.neo4j.driver.internal.cursor.InternalStatementResultCursorFactory;
import org.neo4j.driver.internal.cursor.StatementResultCursorFactory;
import org.neo4j.driver.internal.handlers.AbstractPullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullHandlers;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v4.MessageFormatV4;
import org.neo4j.driver.internal.spi.Connection;

public class BoltProtocolV4
extends BoltProtocolV3 {
    public static final int VERSION = 4;
    public static final BoltProtocol INSTANCE = new BoltProtocolV4();

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV4();
    }

    @Override
    protected StatementResultCursorFactory buildResultCursorFactory(Connection connection, Statement statement, BookmarkHolder bookmarkHolder, ExplicitTransaction tx, RunWithMetadataMessage runMessage, boolean waitForRunResponse) {
        RunResponseHandler runHandler = new RunResponseHandler(METADATA_EXTRACTOR);
        AbstractPullAllResponseHandler pullAllHandler = PullHandlers.newBoltV3PullAllHandler(statement, runHandler, connection, bookmarkHolder, tx);
        BasicPullResponseHandler pullHandler = PullHandlers.newBoltV4PullHandler(statement, runHandler, connection, bookmarkHolder, tx);
        return new InternalStatementResultCursorFactory(connection, runMessage, runHandler, pullHandler, pullAllHandler, waitForRunResponse);
    }

    @Override
    protected void verifyDatabaseNameBeforeTransaction(String databaseName) {
    }

    @Override
    public int version() {
        return 4;
    }
}

