/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.util.Iterables;

public class TransactionMetadataBuilder {
    private static final String BOOKMARKS_METADATA_KEY = "bookmarks";
    private static final String DATABASE_NAME_KEY = "db";
    private static final String TX_TIMEOUT_METADATA_KEY = "tx_timeout";
    private static final String TX_METADATA_METADATA_KEY = "tx_metadata";
    private static final String MODE_KEY = "mode";
    private static final String MODE_READ_VALUE = "r";

    public static Map<String, Value> buildMetadata(Duration txTimeout, Map<String, Value> txMetadata, AccessMode mode, InternalBookmark bookmark) {
        return TransactionMetadataBuilder.buildMetadata(txTimeout, txMetadata, "", mode, bookmark);
    }

    public static Map<String, Value> buildMetadata(Duration txTimeout, Map<String, Value> txMetadata, String databaseName, AccessMode mode, InternalBookmark bookmark) {
        boolean databaseNamePresent;
        boolean bookmarksPresent = bookmark != null && !bookmark.isEmpty();
        boolean txTimeoutPresent = txTimeout != null;
        boolean txMetadataPresent = txMetadata != null && !txMetadata.isEmpty();
        boolean accessModePresent = mode == AccessMode.READ;
        boolean bl = databaseNamePresent = databaseName != null && !databaseName.equals("");
        if (!(bookmarksPresent || txTimeoutPresent || txMetadataPresent || accessModePresent || databaseNamePresent)) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> result = Iterables.newHashMapWithSize(5);
        if (bookmarksPresent) {
            result.put(BOOKMARKS_METADATA_KEY, Values.value(bookmark.values()));
        }
        if (txTimeoutPresent) {
            result.put(TX_TIMEOUT_METADATA_KEY, Values.value(txTimeout.toMillis()));
        }
        if (txMetadataPresent) {
            result.put(TX_METADATA_METADATA_KEY, Values.value(txMetadata));
        }
        if (accessModePresent) {
            result.put(MODE_KEY, Values.value(MODE_READ_VALUE));
        }
        if (databaseNamePresent) {
            result.put(DATABASE_NAME_KEY, Values.value(databaseName));
        }
        return result;
    }
}

