/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Record;
import org.neo4j.driver.Statement;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.StatementResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.connection.DirectConnection;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ServerVersion;

public class RoutingProcedureRunner {
    static final String ROUTING_CONTEXT = "context";
    static final String GET_ROUTING_TABLE = "CALL dbms.cluster.routing.getRoutingTable($context)";
    final RoutingContext context;

    public RoutingProcedureRunner(RoutingContext context) {
        this.context = context;
    }

    public CompletionStage<RoutingProcedureResponse> run(Connection connection, String databaseName, InternalBookmark bookmark) {
        DirectConnection delegate = this.connection(connection);
        Statement procedure = this.procedureStatement(connection.serverVersion(), databaseName);
        BookmarkHolder bookmarkHolder = this.bookmarkHolder(bookmark);
        return this.runProcedure(delegate, procedure, bookmarkHolder).thenCompose(records -> this.releaseConnection(delegate, (List<Record>)records)).handle((records, error) -> RoutingProcedureRunner.processProcedureResponse(procedure, records, error));
    }

    DirectConnection connection(Connection connection) {
        return new DirectConnection(connection, "", AccessMode.WRITE);
    }

    Statement procedureStatement(ServerVersion serverVersion, String databaseName) {
        if (!Objects.equals("", databaseName)) {
            throw new FatalDiscoveryException(String.format("Refreshing routing table for multi-databases is not supported in server version lower than 4.0. Current server version: %s. Database name: `%s`", serverVersion, databaseName));
        }
        return new Statement(GET_ROUTING_TABLE, Values.parameters(ROUTING_CONTEXT, this.context.asMap()));
    }

    BookmarkHolder bookmarkHolder(InternalBookmark ignored) {
        return BookmarkHolder.NO_OP;
    }

    CompletionStage<List<Record>> runProcedure(Connection connection, Statement procedure, BookmarkHolder bookmarkHolder) {
        return connection.protocol().runInAutoCommitTransaction(connection, procedure, bookmarkHolder, TransactionConfig.empty(), true).asyncResult().thenCompose(StatementResultCursor::listAsync);
    }

    private CompletionStage<List<Record>> releaseConnection(Connection connection, List<Record> records) {
        return connection.release().thenApply(ignore -> records);
    }

    private static RoutingProcedureResponse processProcedureResponse(Statement procedure, List<Record> records, Throwable error) {
        Throwable cause = Futures.completionExceptionCause(error);
        if (cause != null) {
            return RoutingProcedureRunner.handleError(procedure, cause);
        }
        return new RoutingProcedureResponse(procedure, records);
    }

    private static RoutingProcedureResponse handleError(Statement procedure, Throwable error) {
        if (error instanceof ClientException) {
            return new RoutingProcedureResponse(procedure, error);
        }
        throw new CompletionException(error);
    }
}

