/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxFromMonoOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxRepeatWhen;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class MonoRepeatWhen<T>
extends FluxFromMonoOperator<T, T> {
    final Function<? super Flux<Long>, ? extends Publisher<?>> whenSourceFactory;

    MonoRepeatWhen(Mono<? extends T> source, Function<? super Flux<Long>, ? extends Publisher<?>> whenSourceFactory) {
        super(source);
        this.whenSourceFactory = Objects.requireNonNull(whenSourceFactory, "whenSourceFactory");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Publisher<?> p;
        FluxRepeatWhen.RepeatWhenOtherSubscriber other = new FluxRepeatWhen.RepeatWhenOtherSubscriber();
        CoreSubscriber<Long> signaller = Operators.serialize(other.completionSignal);
        signaller.onSubscribe(Operators.emptySubscription());
        CoreSubscriber<T> serial = Operators.serialize(actual);
        FluxRepeatWhen.RepeatWhenMainSubscriber<? super T> main = new FluxRepeatWhen.RepeatWhenMainSubscriber<T>(serial, signaller, this.source);
        other.main = main;
        serial.onSubscribe(main);
        try {
            p = Objects.requireNonNull(this.whenSourceFactory.apply(other), "The whenSourceFactory returned a null Publisher");
        }
        catch (Throwable e) {
            actual.onError(Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
        p.subscribe((Subscriber)other);
        if (!main.cancelled) {
            this.source.subscribe(main);
        }
    }
}

