/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BooleanSupplier;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.DrainUtils;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InnerOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Signal;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Subscription;

final class FluxDematerialize<T>
extends FluxOperator<Signal<T>, T> {
    FluxDematerialize(Flux<Signal<T>> source) {
        super(source);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new DematerializeSubscriber<T>(actual));
    }

    static final class DematerializeSubscriber<T>
    extends AbstractQueue<T>
    implements InnerOperator<Signal<T>, T>,
    BooleanSupplier {
        final CoreSubscriber<? super T> actual;
        Subscription s;
        T value;
        boolean done;
        long produced;
        volatile long requested;
        static final AtomicLongFieldUpdater<DematerializeSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(DematerializeSubscriber.class, "requested");
        volatile boolean cancelled;
        Throwable error;

        DematerializeSubscriber(CoreSubscriber<? super T> subscriber) {
            this.actual = subscriber;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.ERROR) {
                return this.error;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.size();
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(1L);
            }
        }

        public void onNext(Signal<T> t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            if (t.isOnComplete()) {
                this.s.cancel();
                this.onComplete();
            } else if (t.isOnError()) {
                this.s.cancel();
                this.onError(t.getThrowable());
            } else if (t.isOnNext()) {
                T v = this.value;
                this.value = t.get();
                if (v != null) {
                    ++this.produced;
                    this.actual.onNext(v);
                }
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.error = t;
            long p = this.produced;
            if (p != 0L) {
                Operators.addCap(REQUESTED, this, -p);
            }
            DrainUtils.postCompleteDelayError(this.actual, this, REQUESTED, this, this, this.error);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            long p = this.produced;
            if (p != 0L) {
                Operators.addCap(REQUESTED, this, -p);
            }
            DrainUtils.postCompleteDelayError(this.actual, this, REQUESTED, this, this, this.error);
        }

        public void request(long n) {
            if (Operators.validate(n) && !DrainUtils.postCompleteRequestDelayError(n, this.actual, this, REQUESTED, this, this, this.error)) {
                this.s.request(n);
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        @Override
        public int size() {
            return this.value == null ? 0 : 1;
        }

        @Override
        public boolean isEmpty() {
            return this.value == null;
        }

        @Override
        public boolean offer(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public T peek() {
            return this.value;
        }

        @Override
        @Nullable
        public T poll() {
            T v = this.value;
            if (v != null) {
                this.value = null;
                return v;
            }
            return null;
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }
    }
}

