/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Record;
import org.neo4j.driver.Statement;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.exceptions.value.ValueException;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.cluster.RoutingProcedureRunner;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Clock;

public class RoutingProcedureClusterCompositionProvider
implements ClusterCompositionProvider {
    private static final String PROTOCOL_ERROR_MESSAGE = "Failed to parse '%s' result received from server due to ";
    private final Clock clock;
    private final RoutingProcedureRunner routingProcedureRunner;

    public RoutingProcedureClusterCompositionProvider(Clock clock, RoutingSettings settings) {
        this(clock, new RoutingProcedureRunner(settings.routingContext()));
    }

    RoutingProcedureClusterCompositionProvider(Clock clock, RoutingProcedureRunner routingProcedureRunner) {
        this.clock = clock;
        this.routingProcedureRunner = routingProcedureRunner;
    }

    @Override
    public CompletionStage<ClusterComposition> getClusterComposition(CompletionStage<Connection> connectionStage, String databaseName) {
        return this.routingProcedureRunner.run(connectionStage, databaseName).thenApply(this::processRoutingResponse);
    }

    private ClusterComposition processRoutingResponse(RoutingProcedureResponse response) {
        ClusterComposition cluster;
        if (!response.isSuccess()) {
            throw new CompletionException(String.format("Failed to run '%s' on server. Please make sure that there is a Neo4j server or cluster up running.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response)), response.error());
        }
        List<Record> records = response.records();
        long now = this.clock.millis();
        if (records.size() != 1) {
            throw new ProtocolException(String.format("Failed to parse '%s' result received from server due to records received '%s' is too few or too many.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response), records.size()));
        }
        try {
            cluster = ClusterComposition.parse(records.get(0), now);
        }
        catch (ValueException e) {
            throw new ProtocolException(String.format("Failed to parse '%s' result received from server due to unparsable record received.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response)), e);
        }
        if (!cluster.hasRoutersAndReaders()) {
            throw new ProtocolException(String.format("Failed to parse '%s' result received from server due to no router or reader found in response.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response)));
        }
        return cluster;
    }

    private static String invokedProcedureString(RoutingProcedureResponse response) {
        Statement statement = response.procedure();
        return statement.text() + " " + statement.parameters();
    }
}

