/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import org.neo4j.driver.Record;
import org.neo4j.driver.Statement;
import org.neo4j.driver.StatementResult;
import org.neo4j.driver.StatementRunner;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.value.MapValue;

public abstract class AbstractStatementRunner
implements StatementRunner {
    @Override
    public final StatementResult run(String statementTemplate, Value parameters) {
        return this.run(new Statement(statementTemplate, parameters));
    }

    @Override
    public final StatementResult run(String statementTemplate, Map<String, Object> statementParameters) {
        return this.run(statementTemplate, AbstractStatementRunner.parameters(statementParameters));
    }

    @Override
    public final StatementResult run(String statementTemplate, Record statementParameters) {
        return this.run(statementTemplate, AbstractStatementRunner.parameters(statementParameters));
    }

    @Override
    public final StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    public static Value parameters(Record record) {
        return record == null ? Values.EmptyMap : AbstractStatementRunner.parameters(record.asMap());
    }

    public static Value parameters(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return Values.EmptyMap;
        }
        return new MapValue(Extract.mapOfValues(map));
    }
}

