/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.driver.Logger;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.security.TrustAllTrustManager;
import org.neo4j.driver.internal.security.TrustOnFirstUseTrustManager;
import org.neo4j.driver.internal.util.CertificateTool;

public class SecurityPlan {
    private final boolean requiresEncryption;
    private final SSLContext sslContext;
    private final boolean routingCompatible;
    private final boolean requiresHostnameVerification;

    public static SecurityPlan forAllCertificates(boolean requiresHostnameVerification) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], new TrustManager[]{new TrustAllTrustManager()}, null);
        return new SecurityPlan(true, sslContext, true, requiresHostnameVerification);
    }

    public static SecurityPlan forCustomCASignedCertificates(File certFile, boolean requiresHostnameVerification) throws GeneralSecurityException, IOException {
        KeyStore trustedKeyStore = KeyStore.getInstance("JKS");
        trustedKeyStore.load(null, null);
        CertificateTool.loadX509Cert(certFile, trustedKeyStore);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(trustedKeyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], trustManagerFactory.getTrustManagers(), null);
        return new SecurityPlan(true, sslContext, true, requiresHostnameVerification);
    }

    public static SecurityPlan forSystemCASignedCertificates(boolean requiresHostnameVerification) throws NoSuchAlgorithmException {
        return new SecurityPlan(true, SSLContext.getDefault(), true, requiresHostnameVerification);
    }

    @Deprecated
    public static SecurityPlan forTrustOnFirstUse(File knownHosts, boolean requiresHostnameVerification, BoltServerAddress address, Logger logger) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], new TrustManager[]{new TrustOnFirstUseTrustManager(address, knownHosts, logger)}, null);
        return new SecurityPlan(true, sslContext, false, requiresHostnameVerification);
    }

    public static SecurityPlan insecure() {
        return new SecurityPlan(false, null, true, false);
    }

    private SecurityPlan(boolean requiresEncryption, SSLContext sslContext, boolean routingCompatible, boolean requiresHostnameVerification) {
        this.requiresEncryption = requiresEncryption;
        this.sslContext = sslContext;
        this.routingCompatible = routingCompatible;
        this.requiresHostnameVerification = requiresHostnameVerification;
    }

    public boolean requiresEncryption() {
        return this.requiresEncryption;
    }

    public boolean isRoutingCompatible() {
        return this.routingCompatible;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public boolean requiresHostnameVerification() {
        return this.requiresHostnameVerification;
    }
}

