/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive.cursor;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.AsyncStatementResultCursor;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.reactive.cursor.InternalStatementResultCursor;
import org.neo4j.driver.internal.reactive.cursor.RxStatementResultCursor;
import org.neo4j.driver.internal.reactive.cursor.StatementResultCursorFactory;
import org.neo4j.driver.internal.spi.Connection;

public class InternalStatementResultCursorFactory
implements StatementResultCursorFactory {
    private final RunResponseHandler runHandler;
    private final Connection connection;
    private final BasicPullResponseHandler pullHandler;
    private final PullAllResponseHandler pullAllHandler;
    private final boolean waitForRunResponse;
    private final Message runMessage;

    public InternalStatementResultCursorFactory(Connection connection, Message runMessage, RunResponseHandler runHandler, BasicPullResponseHandler pullHandler, PullAllResponseHandler pullAllHandler, boolean waitForRunResponse) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(runMessage);
        Objects.requireNonNull(runHandler);
        Objects.requireNonNull(pullHandler);
        Objects.requireNonNull(pullAllHandler);
        this.connection = connection;
        this.runMessage = runMessage;
        this.runHandler = runHandler;
        this.pullHandler = pullHandler;
        this.pullAllHandler = pullAllHandler;
        this.waitForRunResponse = waitForRunResponse;
    }

    @Override
    public CompletionStage<InternalStatementResultCursor> asyncResult() {
        this.connection.writeAndFlush(this.runMessage, this.runHandler, PullMessage.PULL_ALL, this.pullAllHandler);
        if (this.waitForRunResponse) {
            return this.runHandler.runFuture().thenApply(ignore -> new AsyncStatementResultCursor(this.runHandler, this.pullAllHandler));
        }
        return CompletableFuture.completedFuture(new AsyncStatementResultCursor(this.runHandler, this.pullAllHandler));
    }

    @Override
    public CompletionStage<RxStatementResultCursor> rxResult() {
        this.connection.writeAndFlush(this.runMessage, this.runHandler);
        return this.runHandler.runFuture().thenApply(this::composeRxCursor);
    }

    private RxStatementResultCursor composeRxCursor(Throwable runError) {
        return new RxStatementResultCursor(runError, this.runHandler, this.pullHandler);
    }
}

