/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.net.ServerAddress;
import org.neo4j.driver.net.ServerAddressResolver;

public class DnsResolver
implements ServerAddressResolver {
    private final Logger logger;

    public DnsResolver(Logging logging) {
        this.logger = logging.getLog(DnsResolver.class.getSimpleName());
    }

    @Override
    public Set<ServerAddress> resolve(ServerAddress initialRouter) {
        try {
            return Stream.of(InetAddress.getAllByName(initialRouter.host())).map(address -> new BoltServerAddress(initialRouter.host(), address.getHostAddress(), initialRouter.port())).collect(Collectors.toSet());
        }
        catch (UnknownHostException e) {
            this.logger.error("Failed to resolve address `" + initialRouter + "` to IPs due to error: " + e.getMessage(), e);
            return Collections.singleton(initialRouter);
        }
    }
}

