/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.neo4j.driver.Statement;
import org.neo4j.driver.StatementResult;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.StatementResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.AbstractStatementRunner;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.async.ResultCursorsHolder;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.reactive.cursor.InternalStatementResultCursor;
import org.neo4j.driver.internal.reactive.cursor.RxStatementResultCursor;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;

public class ExplicitTransaction
extends AbstractStatementRunner
implements Transaction,
AsyncTransaction {
    private final Connection connection;
    private final BoltProtocol protocol;
    private final BookmarksHolder bookmarksHolder;
    private final ResultCursorsHolder resultCursors;
    private volatile State state = State.ACTIVE;

    public ExplicitTransaction(Connection connection, BookmarksHolder bookmarksHolder) {
        this.connection = connection;
        this.protocol = connection.protocol();
        this.bookmarksHolder = bookmarksHolder;
        this.resultCursors = new ResultCursorsHolder();
    }

    public CompletionStage<ExplicitTransaction> beginAsync(Bookmarks initialBookmarks, TransactionConfig config) {
        return this.protocol.beginTransaction(this.connection, initialBookmarks, config).handle((ignore, beginError) -> {
            if (beginError != null) {
                this.connection.release();
                throw Futures.asCompletionException(beginError);
            }
            return this;
        });
    }

    @Override
    public void success() {
        if (this.state == State.ACTIVE) {
            this.state = State.MARKED_SUCCESS;
        }
    }

    @Override
    public void failure() {
        if (this.state == State.ACTIVE || this.state == State.MARKED_SUCCESS) {
            this.state = State.MARKED_FAILED;
        }
    }

    @Override
    public void close() {
        Futures.blockingGet(this.closeAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the transaction"));
    }

    CompletionStage<Void> closeAsync() {
        if (this.state == State.MARKED_SUCCESS) {
            return this.commitAsync();
        }
        if (this.state != State.COMMITTED && this.state != State.ROLLED_BACK) {
            return this.rollbackAsync();
        }
        return Futures.completedWithNull();
    }

    @Override
    public CompletionStage<Void> commitAsync() {
        if (this.state == State.COMMITTED) {
            return Futures.completedWithNull();
        }
        if (this.state == State.ROLLED_BACK) {
            return Futures.failedFuture(new ClientException("Can't commit, transaction has been rolled back"));
        }
        return this.resultCursors.retrieveNotConsumedError().thenCompose(error -> this.doCommitAsync().handle(ExplicitTransaction.handleCommitOrRollback(error))).whenComplete((ignore, error) -> this.transactionClosed(error == null));
    }

    @Override
    public CompletionStage<Void> rollbackAsync() {
        if (this.state == State.COMMITTED) {
            return Futures.failedFuture(new ClientException("Can't rollback, transaction has been committed"));
        }
        if (this.state == State.ROLLED_BACK) {
            return Futures.completedWithNull();
        }
        return this.resultCursors.retrieveNotConsumedError().thenCompose(error -> this.doRollbackAsync().handle(ExplicitTransaction.handleCommitOrRollback(error))).whenComplete((ignore, error) -> this.transactionClosed(false));
    }

    @Override
    public StatementResult run(Statement statement) {
        StatementResultCursor cursor = Futures.blockingGet(this.run(statement, false), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in transaction"));
        return new InternalStatementResult(this.connection, cursor);
    }

    @Override
    public CompletionStage<StatementResultCursor> runAsync(Statement statement) {
        return this.run(statement, true);
    }

    private CompletionStage<InternalStatementResultCursor> run(Statement statement, boolean waitForRunResponse) {
        this.ensureCanRunQueries();
        CompletionStage<InternalStatementResultCursor> cursorStage = this.protocol.runInExplicitTransaction(this.connection, statement, this, waitForRunResponse).asyncResult();
        this.resultCursors.add(cursorStage);
        return cursorStage;
    }

    public CompletionStage<RxStatementResultCursor> runRx(Statement statement) {
        this.ensureCanRunQueries();
        CompletionStage<RxStatementResultCursor> cursorStage = this.protocol.runInExplicitTransaction(this.connection, statement, this, false).rxResult();
        this.resultCursors.add(cursorStage);
        return cursorStage;
    }

    private void ensureCanRunQueries() {
        if (this.state == State.COMMITTED) {
            throw new ClientException("Cannot run more statements in this transaction, it has been committed");
        }
        if (this.state == State.ROLLED_BACK) {
            throw new ClientException("Cannot run more statements in this transaction, it has been rolled back");
        }
        if (this.state == State.MARKED_FAILED) {
            throw new ClientException("Cannot run more statements in this transaction, it has been marked for failure. Please either rollback or close this transaction");
        }
        if (this.state == State.TERMINATED) {
            throw new ClientException("Cannot run more statements in this transaction, it has either experienced an fatal error or was explicitly terminated");
        }
    }

    @Override
    public boolean isOpen() {
        return this.state != State.COMMITTED && this.state != State.ROLLED_BACK;
    }

    public void markTerminated() {
        this.state = State.TERMINATED;
    }

    private CompletionStage<Void> doCommitAsync() {
        if (this.state == State.TERMINATED) {
            return Futures.failedFuture(new ClientException("Transaction can't be committed. It has been rolled back either because of an error or explicit termination"));
        }
        return this.protocol.commitTransaction(this.connection).thenAccept(this.bookmarksHolder::setBookmarks);
    }

    private CompletionStage<Void> doRollbackAsync() {
        if (this.state == State.TERMINATED) {
            return Futures.completedWithNull();
        }
        return this.protocol.rollbackTransaction(this.connection);
    }

    private static BiFunction<Void, Throwable, Void> handleCommitOrRollback(Throwable cursorFailure) {
        return (ignore, commitOrRollbackError) -> {
            CompletionException combinedError = Futures.combineErrors(cursorFailure, commitOrRollbackError);
            if (combinedError != null) {
                throw combinedError;
            }
            return null;
        };
    }

    private void transactionClosed(boolean isCommitted) {
        this.state = isCommitted ? State.COMMITTED : State.ROLLED_BACK;
        this.connection.release();
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        this.connection.terminateAndRelease(reason);
    }

    private static enum State {
        ACTIVE,
        MARKED_SUCCESS,
        MARKED_FAILED,
        TERMINATED,
        COMMITTED,
        ROLLED_BACK;

    }
}

