/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.driver.Record;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.reactive.cursor.InternalStatementResultCursor;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.summary.ResultSummary;

public class AsyncStatementResultCursor
implements InternalStatementResultCursor {
    private final RunResponseHandler runResponseHandler;
    private final PullAllResponseHandler pullAllHandler;

    public AsyncStatementResultCursor(RunResponseHandler runResponseHandler, PullAllResponseHandler pullAllHandler) {
        this.runResponseHandler = runResponseHandler;
        this.pullAllHandler = pullAllHandler;
    }

    @Override
    public List<String> keys() {
        return this.runResponseHandler.statementKeys();
    }

    @Override
    public CompletionStage<ResultSummary> summaryAsync() {
        return this.pullAllHandler.summaryAsync();
    }

    @Override
    public CompletionStage<Record> nextAsync() {
        return this.pullAllHandler.nextAsync();
    }

    @Override
    public CompletionStage<Record> peekAsync() {
        return this.pullAllHandler.peekAsync();
    }

    @Override
    public CompletionStage<Record> singleAsync() {
        return this.nextAsync().thenCompose(firstRecord -> {
            if (firstRecord == null) {
                throw new NoSuchRecordException("Cannot retrieve a single record, because this result is empty.");
            }
            return this.nextAsync().thenApply(secondRecord -> {
                if (secondRecord != null) {
                    throw new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record.");
                }
                return firstRecord;
            });
        });
    }

    @Override
    public CompletionStage<ResultSummary> consumeAsync() {
        return this.pullAllHandler.consumeAsync();
    }

    @Override
    public CompletionStage<ResultSummary> forEachAsync(Consumer<Record> action) {
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        this.internalForEachAsync(action, resultFuture);
        return resultFuture.thenCompose(ignore -> this.summaryAsync());
    }

    @Override
    public CompletionStage<List<Record>> listAsync() {
        return this.listAsync(Function.identity());
    }

    @Override
    public <T> CompletionStage<List<T>> listAsync(Function<Record, T> mapFunction) {
        return this.pullAllHandler.listAsync(mapFunction);
    }

    @Override
    public CompletionStage<Throwable> failureAsync() {
        return this.pullAllHandler.failureAsync();
    }

    private void internalForEachAsync(Consumer<Record> action, CompletableFuture<Void> resultFuture) {
        CompletionStage<Record> recordFuture = this.nextAsync();
        recordFuture.whenCompleteAsync((record, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                resultFuture.completeExceptionally(error);
            } else if (record != null) {
                try {
                    action.accept((Record)record);
                }
                catch (Throwable actionError) {
                    resultFuture.completeExceptionally(actionError);
                    return;
                }
                this.internalForEachAsync(action, resultFuture);
            } else {
                resultFuture.complete(null);
            }
        });
    }
}

