/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.messaging.request.TransactionStartingMessage;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.TransactionConfig;
import org.neo4j.driver.v1.Value;

public class RunWithMetadataMessage
extends TransactionStartingMessage {
    public static final byte SIGNATURE = 16;
    private final String statement;
    private final Map<String, Value> parameters;

    public RunWithMetadataMessage(String statement, Map<String, Value> parameters, Bookmarks bookmarks, TransactionConfig config, AccessMode mode) {
        this(statement, parameters, bookmarks, config.timeout(), config.metadata(), mode);
    }

    public RunWithMetadataMessage(String statement, Map<String, Value> parameters, Bookmarks bookmarks, Duration txTimeout, Map<String, Value> txMetadata, AccessMode mode) {
        super(bookmarks, txTimeout, txMetadata, mode);
        this.statement = statement;
        this.parameters = parameters;
    }

    public String statement() {
        return this.statement;
    }

    public Map<String, Value> parameters() {
        return this.parameters;
    }

    @Override
    public byte signature() {
        return 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunWithMetadataMessage that = (RunWithMetadataMessage)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.parameters, this.metadata);
    }

    public String toString() {
        return "RUN \"" + this.statement + "\" " + this.parameters + " " + this.metadata;
    }
}

