/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.spi.AutoReadManagingResponseHandler;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.util.Function;

public abstract class PullAllResponseHandler
implements AutoReadManagingResponseHandler {
    private static final Queue<Record> UNINITIALIZED_RECORDS = Iterables.emptyQueue();
    static final int RECORD_BUFFER_LOW_WATERMARK = Integer.getInteger("recordBufferLowWatermark", 300);
    static final int RECORD_BUFFER_HIGH_WATERMARK = Integer.getInteger("recordBufferHighWatermark", 1000);
    private final Statement statement;
    private final RunResponseHandler runResponseHandler;
    protected final MetadataExtractor metadataExtractor;
    protected final Connection connection;
    private Queue<Record> records = UNINITIALIZED_RECORDS;
    private boolean autoReadManagementEnabled = true;
    private boolean finished;
    private Throwable failure;
    private ResultSummary summary;
    private boolean ignoreRecords;
    private CompletableFuture<Record> recordFuture;
    private CompletableFuture<Throwable> failureFuture;

    public PullAllResponseHandler(Statement statement, RunResponseHandler runResponseHandler, Connection connection, MetadataExtractor metadataExtractor) {
        this.statement = Objects.requireNonNull(statement);
        this.runResponseHandler = Objects.requireNonNull(runResponseHandler);
        this.metadataExtractor = Objects.requireNonNull(metadataExtractor);
        this.connection = Objects.requireNonNull(connection);
    }

    @Override
    public synchronized void onSuccess(Map<String, Value> metadata) {
        this.finished = true;
        this.summary = this.extractResultSummary(metadata);
        this.afterSuccess(metadata);
        this.completeRecordFuture(null);
        this.completeFailureFuture(null);
    }

    protected abstract void afterSuccess(Map<String, Value> var1);

    @Override
    public synchronized void onFailure(Throwable error) {
        this.finished = true;
        this.summary = this.extractResultSummary(Collections.emptyMap());
        this.afterFailure(error);
        boolean failedRecordFuture = this.failRecordFuture(error);
        if (failedRecordFuture) {
            this.completeFailureFuture(null);
        } else {
            boolean completedFailureFuture = this.completeFailureFuture(error);
            if (!completedFailureFuture) {
                this.failure = error;
            }
        }
    }

    protected abstract void afterFailure(Throwable var1);

    @Override
    public synchronized void onRecord(Value[] fields) {
        if (this.ignoreRecords) {
            this.completeRecordFuture(null);
        } else {
            InternalRecord record = new InternalRecord(this.runResponseHandler.statementKeys(), fields);
            this.enqueueRecord(record);
            this.completeRecordFuture(record);
        }
    }

    @Override
    public synchronized void disableAutoReadManagement() {
        this.autoReadManagementEnabled = false;
    }

    public synchronized CompletionStage<Record> peekAsync() {
        Record record = this.records.peek();
        if (record == null) {
            if (this.failure != null) {
                return Futures.failedFuture(this.extractFailure());
            }
            if (this.ignoreRecords || this.finished) {
                return Futures.completedWithNull();
            }
            if (this.recordFuture == null) {
                this.recordFuture = new CompletableFuture();
            }
            return this.recordFuture;
        }
        return CompletableFuture.completedFuture(record);
    }

    public synchronized CompletionStage<Record> nextAsync() {
        return this.peekAsync().thenApply(ignore -> this.dequeueRecord());
    }

    public synchronized CompletionStage<ResultSummary> summaryAsync() {
        return this.failureAsync().thenApply(error -> {
            if (error != null) {
                throw Futures.asCompletionException(error);
            }
            return this.summary;
        });
    }

    public synchronized CompletionStage<ResultSummary> consumeAsync() {
        this.ignoreRecords = true;
        this.records.clear();
        return this.summaryAsync();
    }

    public synchronized <T> CompletionStage<List<T>> listAsync(Function<Record, T> mapFunction) {
        return this.failureAsync().thenApply(error -> {
            if (error != null) {
                throw Futures.asCompletionException(error);
            }
            return this.recordsAsList(mapFunction);
        });
    }

    public synchronized CompletionStage<Throwable> failureAsync() {
        if (this.failure != null) {
            return CompletableFuture.completedFuture(this.extractFailure());
        }
        if (this.finished) {
            return Futures.completedWithNull();
        }
        if (this.failureFuture == null) {
            this.enableAutoRead();
            this.failureFuture = new CompletableFuture();
        }
        return this.failureFuture;
    }

    private void enqueueRecord(Record record) {
        boolean shouldBufferAllRecords;
        if (this.records == UNINITIALIZED_RECORDS) {
            this.records = new ArrayDeque<Record>();
        }
        this.records.add(record);
        boolean bl = shouldBufferAllRecords = this.failureFuture != null;
        if (!shouldBufferAllRecords && this.records.size() > RECORD_BUFFER_HIGH_WATERMARK) {
            this.disableAutoRead();
        }
    }

    private Record dequeueRecord() {
        Record record = this.records.poll();
        if (this.records.size() < RECORD_BUFFER_LOW_WATERMARK) {
            this.enableAutoRead();
        }
        return record;
    }

    private <T> List<T> recordsAsList(Function<Record, T> mapFunction) {
        if (!this.finished) {
            throw new IllegalStateException("Can't get records as list because SUCCESS or FAILURE did not arrive");
        }
        ArrayList<T> result = new ArrayList<T>(this.records.size());
        while (!this.records.isEmpty()) {
            Record record = this.records.poll();
            result.add(mapFunction.apply(record));
        }
        return result;
    }

    private Throwable extractFailure() {
        if (this.failure == null) {
            throw new IllegalStateException("Can't extract failure because it does not exist");
        }
        Throwable error = this.failure;
        this.failure = null;
        return error;
    }

    private void completeRecordFuture(Record record) {
        if (this.recordFuture != null) {
            CompletableFuture<Record> future = this.recordFuture;
            this.recordFuture = null;
            future.complete(record);
        }
    }

    private boolean failRecordFuture(Throwable error) {
        if (this.recordFuture != null) {
            CompletableFuture<Record> future = this.recordFuture;
            this.recordFuture = null;
            future.completeExceptionally(error);
            return true;
        }
        return false;
    }

    private boolean completeFailureFuture(Throwable error) {
        if (this.failureFuture != null) {
            CompletableFuture<Throwable> future = this.failureFuture;
            this.failureFuture = null;
            future.complete(error);
            return true;
        }
        return false;
    }

    private ResultSummary extractResultSummary(Map<String, Value> metadata) {
        long resultAvailableAfter = this.runResponseHandler.resultAvailableAfter();
        return this.metadataExtractor.extractSummary(this.statement, this.connection, resultAvailableAfter, metadata);
    }

    private void enableAutoRead() {
        if (this.autoReadManagementEnabled) {
            this.connection.enableAutoRead();
        }
    }

    private void disableAutoRead() {
        if (this.autoReadManagementEnabled) {
            this.connection.disableAutoRead();
        }
    }
}

