/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;

public class RoutingProcedureResponse {
    private final Statement procedure;
    private final List<Record> records;
    private final Throwable error;

    public RoutingProcedureResponse(Statement procedure, List<Record> records) {
        this(procedure, records, null);
    }

    public RoutingProcedureResponse(Statement procedure, Throwable error) {
        this(procedure, null, error);
    }

    private RoutingProcedureResponse(Statement procedure, List<Record> records, Throwable error) {
        this.procedure = procedure;
        this.records = records;
        this.error = error;
    }

    public boolean isSuccess() {
        return this.records != null;
    }

    public Statement procedure() {
        return this.procedure;
    }

    public List<Record> records() {
        if (!this.isSuccess()) {
            throw new IllegalStateException("Can't access records of a failed result", this.error);
        }
        return this.records;
    }

    public Throwable error() {
        if (this.isSuccess()) {
            throw new IllegalStateException("Can't access error of a succeeded result " + this.records);
        }
        return this.error;
    }
}

