/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public class HelloMessage
implements Message {
    public static final byte SIGNATURE = 1;
    private static final String USER_AGENT_METADATA_KEY = "user_agent";
    private final Map<String, Value> metadata;

    public HelloMessage(String userAgent, Map<String, Value> authToken) {
        this.metadata = HelloMessage.buildMetadata(userAgent, authToken);
    }

    public Map<String, Value> metadata() {
        return this.metadata;
    }

    @Override
    public byte signature() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelloMessage that = (HelloMessage)o;
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.metadata);
    }

    public String toString() {
        HashMap<String, Value> metadataCopy = new HashMap<String, Value>(this.metadata);
        metadataCopy.replace("credentials", Values.value("******"));
        return "HELLO " + metadataCopy;
    }

    private static Map<String, Value> buildMetadata(String userAgent, Map<String, Value> authToken) {
        HashMap<String, Value> result = new HashMap<String, Value>(authToken);
        result.put(USER_AGENT_METADATA_KEY, Values.value(userAgent));
        return result;
    }
}

