/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.types;

import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.v1.Value;

public enum TypeConstructor {
    ANY_TyCon{

        @Override
        public String typeName() {
            return "ANY";
        }

        @Override
        public boolean covers(Value value) {
            return !value.isNull();
        }
    }
    ,
    BOOLEAN_TyCon{

        @Override
        public String typeName() {
            return "BOOLEAN";
        }
    }
    ,
    BYTES_TyCon{

        @Override
        public String typeName() {
            return "BYTES";
        }
    }
    ,
    STRING_TyCon{

        @Override
        public String typeName() {
            return "STRING";
        }
    }
    ,
    NUMBER_TyCon{

        @Override
        public boolean covers(Value value) {
            TypeConstructor valueType = TypeConstructor.typeConstructorOf(value);
            return valueType == this || valueType == INTEGER_TyCon || valueType == FLOAT_TyCon;
        }

        @Override
        public String typeName() {
            return "NUMBER";
        }
    }
    ,
    INTEGER_TyCon{

        @Override
        public String typeName() {
            return "INTEGER";
        }
    }
    ,
    FLOAT_TyCon{

        @Override
        public String typeName() {
            return "FLOAT";
        }
    }
    ,
    LIST_TyCon{

        @Override
        public String typeName() {
            return "LIST";
        }
    }
    ,
    MAP_TyCon{

        @Override
        public String typeName() {
            return "MAP";
        }

        @Override
        public boolean covers(Value value) {
            TypeConstructor valueType = TypeConstructor.typeConstructorOf(value);
            return valueType == MAP_TyCon || valueType == NODE_TyCon || valueType == RELATIONSHIP_TyCon;
        }
    }
    ,
    NODE_TyCon{

        @Override
        public String typeName() {
            return "NODE";
        }
    }
    ,
    RELATIONSHIP_TyCon{

        @Override
        public String typeName() {
            return "RELATIONSHIP";
        }
    }
    ,
    PATH_TyCon{

        @Override
        public String typeName() {
            return "PATH";
        }
    }
    ,
    POINT_2D_TyCon{

        @Override
        public String typeName() {
            return "POINT";
        }
    }
    ,
    POINT_3D_TyCon{

        @Override
        public String typeName() {
            return "POINT";
        }
    }
    ,
    NULL_TyCon{

        @Override
        public String typeName() {
            return "NULL";
        }
    };


    private static TypeConstructor typeConstructorOf(Value value) {
        return ((InternalValue)value).typeConstructor();
    }

    public abstract String typeName();

    public boolean covers(Value value) {
        return this == TypeConstructor.typeConstructorOf(value);
    }
}

