/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import java.util.Objects;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.ChannelConnector;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelHealthChecker;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPoolHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.FixedChannelPool;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class NettyChannelPool
extends FixedChannelPool {
    private static final int MAX_PENDING_ACQUIRES = Integer.MAX_VALUE;
    private static final boolean RELEASE_HEALTH_CHECK = false;
    private final BoltServerAddress address;
    private final ChannelConnector connector;

    public NettyChannelPool(BoltServerAddress address, ChannelConnector connector, Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck, long acquireTimeoutMillis, int maxConnections) {
        super(bootstrap, handler, healthCheck, FixedChannelPool.AcquireTimeoutAction.FAIL, acquireTimeoutMillis, maxConnections, Integer.MAX_VALUE, false);
        this.address = Objects.requireNonNull(address);
        this.connector = Objects.requireNonNull(connector);
    }

    @Override
    protected ChannelFuture connectChannel(Bootstrap bootstrap) {
        ChannelFuture channelFuture = this.connector.connect(this.address, bootstrap);
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (future.isSuccess()) {
                this.handler().channelCreated(channelFuture.channel());
            }
        }));
        return channelFuture;
    }
}

