/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.List;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.util.Function;

public class InternalStatementResult
implements StatementResult {
    private final StatementResultCursor cursor;
    private List<String> keys;

    public InternalStatementResult(StatementResultCursor cursor) {
        this.cursor = cursor;
    }

    @Override
    public List<String> keys() {
        if (this.keys == null) {
            Futures.getBlocking(this.cursor.peekAsync());
            this.keys = this.cursor.keys();
        }
        return this.keys;
    }

    @Override
    public boolean hasNext() {
        return Futures.getBlocking(this.cursor.peekAsync()) != null;
    }

    @Override
    public Record next() {
        Record record = Futures.getBlocking(this.cursor.nextAsync());
        if (record == null) {
            throw new NoSuchRecordException("No more records");
        }
        return record;
    }

    @Override
    public Record single() {
        return Futures.getBlocking(this.cursor.singleAsync());
    }

    @Override
    public Record peek() {
        Record record = Futures.getBlocking(this.cursor.peekAsync());
        if (record == null) {
            throw new NoSuchRecordException("Cannot peek past the last record");
        }
        return record;
    }

    @Override
    public List<Record> list() {
        return Futures.getBlocking(this.cursor.listAsync());
    }

    @Override
    public <T> List<T> list(Function<Record, T> mapFunction) {
        return Futures.getBlocking(this.cursor.listAsync(mapFunction));
    }

    @Override
    public ResultSummary consume() {
        return Futures.getBlocking(this.cursor.consumeAsync());
    }

    @Override
    public ResultSummary summary() {
        return Futures.getBlocking(this.cursor.summaryAsync());
    }

    @Override
    public void remove() {
        throw new ClientException("Removing records from a result is not supported.");
    }
}

