/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import io.netty.util.concurrent.Promise;
import java.util.Map;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Value;

public class ResetResponseHandler
implements ResponseHandler {
    private final Channel channel;
    private final ChannelPool pool;
    private final InboundMessageDispatcher messageDispatcher;
    private final Clock clock;
    private final Promise<Void> releasePromise;

    public ResetResponseHandler(Channel channel, ChannelPool pool, InboundMessageDispatcher messageDispatcher, Clock clock) {
        this(channel, pool, messageDispatcher, clock, null);
    }

    public ResetResponseHandler(Channel channel, ChannelPool pool, InboundMessageDispatcher messageDispatcher, Clock clock, Promise<Void> releasePromise) {
        this.channel = channel;
        this.pool = pool;
        this.messageDispatcher = messageDispatcher;
        this.clock = clock;
        this.releasePromise = releasePromise;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.releaseChannel();
    }

    @Override
    public void onFailure(Throwable error) {
        this.releaseChannel();
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private void releaseChannel() {
        this.messageDispatcher.unMuteAckFailure();
        ChannelAttributes.setLastUsedTimestamp(this.channel, this.clock.millis());
        if (this.releasePromise == null) {
            this.pool.release(this.channel);
        } else {
            this.pool.release(this.channel, this.releasePromise);
        }
    }
}

