/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import java.util.Objects;
import org.neo4j.driver.internal.async.BoltServerAddress;
import org.neo4j.driver.internal.async.ChannelConnector;

public class NettyChannelPool
extends FixedChannelPool {
    private static final int MAX_PENDING_ACQUIRES = Integer.MAX_VALUE;
    private static final boolean RELEASE_HEALTH_CHECK = false;
    private final BoltServerAddress address;
    private final ChannelConnector connector;

    public NettyChannelPool(BoltServerAddress address, ChannelConnector connector, Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck, long acquireTimeoutMillis, int maxConnections) {
        super(bootstrap, handler, healthCheck, FixedChannelPool.AcquireTimeoutAction.FAIL, acquireTimeoutMillis, maxConnections, Integer.MAX_VALUE, false);
        this.address = Objects.requireNonNull(address);
        this.connector = Objects.requireNonNull(connector);
    }

    protected ChannelFuture connectChannel(Bootstrap bootstrap) {
        ChannelFuture channelFuture = this.connector.connect(this.address, bootstrap);
        channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                this.handler().channelCreated(channelFuture.channel());
            }
        });
        return channelFuture;
    }
}

