/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.outbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.neo4j.driver.internal.async.ProtocolUtil;
import org.neo4j.driver.internal.async.outbound.ChunkAwareByteBufOutput;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class OutboundMessageHandler
extends MessageToMessageEncoder<Message> {
    public static final String NAME = OutboundMessageHandler.class.getSimpleName();
    private final MessageFormat messageFormat;
    private final ChunkAwareByteBufOutput output;
    private final MessageFormat.Writer writer;
    private final Logger log;

    public OutboundMessageHandler(MessageFormat messageFormat, Logging logging) {
        this(messageFormat, true, logging.getLog(NAME));
    }

    private OutboundMessageHandler(MessageFormat messageFormat, boolean byteArraySupportEnabled, Logger log) {
        this.messageFormat = messageFormat;
        this.output = new ChunkAwareByteBufOutput();
        this.writer = messageFormat.newWriter(this.output, byteArraySupportEnabled);
        this.log = log;
    }

    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) {
        this.log.debug("Sending message %s", msg);
        ByteBuf messageBuf = ctx.alloc().ioBuffer();
        this.output.start(messageBuf);
        try {
            this.writer.write(msg);
        }
        catch (Throwable error) {
            throw new EncoderException("Failed to write outbound message: " + msg, error);
        }
        finally {
            this.output.stop();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Message %s encoded as\n%s\n", msg, ByteBufUtil.prettyHexDump((ByteBuf)messageBuf));
        }
        out.add(messageBuf);
        out.add(ProtocolUtil.messageBoundary());
    }

    public OutboundMessageHandler withoutByteArraySupport() {
        return new OutboundMessageHandler(this.messageFormat, false, this.log);
    }
}

