/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.summary.ResultSummary;

public class Main {
    private static final int ITERATIONS = 200;
    private static final String QUERY1 = "RETURN 1";
    private static final String QUERY2 = "MATCH (n:ActiveItem) RETURN n LIMIT 50000";
    private static final String QUERY3 = "MATCH (s:Sku{sku_no: {skuNo}})-[:HAS_ITEM_SOURCE]->(i:ItemSource{itemsource: {itemSource}})\n//Get master sku for auxiliary item\nOPTIONAL MATCH (s)-[:AUXILIARY_FOR]->(master_sku:Sku) WHERE NOT s.display_auxiliary_content\n//Get New item for Used item\nOPTIONAL MATCH (s)-[:USED_VERSION_OF]->(new_sku:Sku)\n//Get other items like kit details and bundle includes\nOPTIONAL MATCH (s)-[r:RELATED_ITEM]->(ri:Sku)\nWITH i, r, coalesce(ri, master_sku, new_sku, s) as sku, coalesce(master_sku, new_sku, s) as final_sku\nOPTIONAL MATCH (sku)-[:DESCRIBED_AS]->(d:Desc)\nOPTIONAL MATCH (sku)-[:FEATURED_WITH]->(f:Feature)\n//Get itemsource of related item\nOPTIONAL MATCH (sku)-[:HAS_ITEM_SOURCE]->(relatedItemSource:ItemSource)<-[:KIT_CONTAINS|INCLUDES_ITEMSOURCE*1..2]-(i)\nWITH i, final_sku, sku, d, f, relatedItemSource, r\n\tORDER BY f.seqnum\nWITH final_sku, sku, r, d, i, relatedItemSource, CASE WHEN f IS NOT null THEN collect({\n\ttitle: f.title,\n\tbody: f.body,\n\tisHeader: f.is_header,\n\tnote: f.note\n}) END as featureList ORDER BY coalesce(r.seqnum,0)\n//Get description of kit header or bundle heder\nOPTIONAL MATCH (final_sku)-[:DESCRIBED_AS]->(mainDescription:Desc) WHERE r is not null\nRETURN\ncollect(DISTINCT CASE WHEN mainDescription is not null THEN\n{\n\titemName: null,\n\tdescription: {\n\t\ttext: mainDescription.description,\n\t\tnote: mainDescription.description_note\n\t},\n\tfeatures: {\n\t  \tnote: null,\n\t\tfeatureList: null\n\t},\n\tupc: i.upc,\n\thasThirdPartyContent: final_sku.has_third_party_content\n} END)\n+\ncollect({\n\titemName: r.item_name,\n\tdescription: {\n\t\ttext: d.description,\n\t\tnote: d.description_note\n\t},\n\tfeatures: {\n\t\tnote: d.feature_note,\n\t\tfeatureList: featureList\n\t},\n\tupc: coalesce(relatedItemSource, i).upc,\n\thasThirdPartyContent: sku.has_third_party_content\n}) AS overview;\n";
    private static final String QUERY = "MATCH (n:ActiveItem) RETURN n LIMIT 50000";
    private static final Map<String, Object> PARAMS1 = new HashMap<String, Object>();
    private static final Map<String, Object> PARAMS2 = new HashMap<String, Object>();
    private static final Map<String, Object> PARAMS = PARAMS1;
    private static final String SCHEME = "bolt+routing";
    private static final String USER = "neo4j";
    private static final String PASSWORD = "test";
    private static final String HOST = "ec2-34-249-23-195.eu-west-1.compute.amazonaws.com";
    private static final int PORT = 26000;
    private static final String URI = "bolt+routing://ec2-34-249-23-195.eu-west-1.compute.amazonaws.com:26000";

    public static void main(String[] args) throws Throwable {
        Main.testSessionRun();
        Main.testSessionRunAsync();
        Main.testTxRun();
        Main.testTxRunAsync();
    }

    private static void testSessionRun() throws Throwable {
        Main.test("Session#run()", new Action(){

            @Override
            public void apply(Driver driver, MutableInt recordsRead, Set<String> serversUsed) {
                try (Session session = driver.session(AccessMode.READ);){
                    StatementResult result = session.run("MATCH (n:ActiveItem) RETURN n LIMIT 50000", PARAMS);
                    while (result.hasNext()) {
                        Record record = result.next();
                        Main.useRecord(record);
                        recordsRead.increment();
                    }
                    serversUsed.add(result.summary().server().address());
                }
            }
        });
    }

    private static void testSessionRunAsync() throws Throwable {
        Main.test("Session#runAsync()", new Action(){

            @Override
            public void apply(Driver driver, MutableInt recordsRead, Set<String> serversUsed) {
                Record record;
                Session session = driver.session(AccessMode.READ);
                CompletionStage<StatementResultCursor> cursorFuture = session.runAsync("MATCH (n:ActiveItem) RETURN n LIMIT 50000", PARAMS);
                StatementResultCursor cursor = (StatementResultCursor)Main.await(cursorFuture);
                while ((record = (Record)Main.await(cursor.nextAsync())) != null) {
                    Main.useRecord(record);
                    recordsRead.increment();
                }
                serversUsed.add(((ResultSummary)Main.await(cursor.summaryAsync())).server().address());
                Main.await(session.closeAsync());
            }
        });
    }

    private static void testTxRun() throws Throwable {
        Main.test("Transaction#run()", new Action(){

            @Override
            public void apply(Driver driver, MutableInt recordsRead, Set<String> serversUsed) {
                try (Session session = driver.session(AccessMode.READ);
                     Transaction tx = session.beginTransaction();){
                    StatementResult result = tx.run("MATCH (n:ActiveItem) RETURN n LIMIT 50000", PARAMS);
                    while (result.hasNext()) {
                        Record record = result.next();
                        Main.useRecord(record);
                        recordsRead.increment();
                    }
                    tx.success();
                    serversUsed.add(result.summary().server().address());
                }
            }
        });
    }

    private static void testTxRunAsync() throws Throwable {
        Main.test("Transaction#runAsync()", new Action(){

            @Override
            public void apply(Driver driver, MutableInt recordsRead, Set<String> serversUsed) {
                Record record;
                Session session = driver.session(AccessMode.READ);
                Transaction tx = (Transaction)Main.await(session.beginTransactionAsync());
                StatementResultCursor cursor = (StatementResultCursor)Main.await(tx.runAsync("MATCH (n:ActiveItem) RETURN n LIMIT 50000", PARAMS));
                while ((record = (Record)Main.await(cursor.nextAsync())) != null) {
                    Main.useRecord(record);
                    recordsRead.increment();
                }
                serversUsed.add(((ResultSummary)Main.await(cursor.summaryAsync())).server().address());
                Main.await(tx.commitAsync());
                Main.await(session.closeAsync());
            }
        });
    }

    private static void test(String actionName, Action action) throws Throwable {
        AuthToken authToken = AuthTokens.basic(USER, PASSWORD);
        Config config = Config.build().withoutEncryption().toConfig();
        List<Long> timings = new ArrayList<Long>();
        MutableInt recordsRead = new MutableInt();
        ConcurrentSet serversUsed = new ConcurrentSet();
        try (Driver driver = GraphDatabase.driver(URI, authToken, config);){
            for (int i = 0; i < 200; ++i) {
                long start = System.nanoTime();
                action.apply(driver, recordsRead, (Set<String>)serversUsed);
                long end = System.nanoTime();
                timings.add(TimeUnit.NANOSECONDS.toMillis(end - start));
            }
        }
        timings = Main.clean(timings);
        System.out.println("============================================================");
        System.out.println(actionName + ": mean --> " + Main.mean(timings) + "ms, stdDev --> " + Main.stdDev(timings));
        System.out.println(actionName + ": timings --> " + timings);
        System.out.println(actionName + ": recordsRead --> " + recordsRead);
        System.out.println(actionName + ": serversUsed --> " + serversUsed);
        System.out.println("============================================================");
    }

    private static List<Long> clean(List<Long> timings) {
        int warmup = timings.size() / 10;
        return timings.subList(warmup, timings.size());
    }

    private static long mean(List<Long> timings) {
        long sum = 0L;
        for (Long timing : timings) {
            sum += timing.longValue();
        }
        return sum / (long)timings.size();
    }

    private static double stdDev(List<Long> timings) {
        long mean = Main.mean(timings);
        long sum = 0L;
        for (Long timing : timings) {
            sum += (timing - mean) * (timing - mean);
        }
        double squaredDiffMean = sum / (long)timings.size();
        return Math.sqrt(squaredDiffMean);
    }

    private static <T> T await(CompletionStage<T> stage) {
        try {
            return stage.toCompletableFuture().get();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void useRecord(Record record) {
        if (record.keys().size() > 5) {
            System.out.println("Hello");
        }
        if (record.get(0).isNull()) {
            System.out.println(" ");
        }
        if (record.get("A") == null) {
            System.out.println("World");
        }
    }

    static {
        PARAMS1.put("skuNo", 366421);
        PARAMS1.put("itemSource", "REG");
        PARAMS1.put("catalogId", 2);
        PARAMS1.put("locale", "en");
        HashMap<String, Object> tmpObj = new HashMap<String, Object>();
        tmpObj.put("skuNo", 366421);
        tmpObj.put("itemSource", "REG");
        PARAMS1.put("itemList", Collections.singletonList(tmpObj));
    }

    private static class MutableInt {
        int value;

        private MutableInt() {
        }

        void increment() {
            ++this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static interface Action {
        public void apply(Driver var1, MutableInt var2, Set<String> var3);
    }
}

