/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CodecException;
import java.io.IOException;
import java.util.Objects;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class ChannelErrorHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log;
    private InboundMessageDispatcher messageDispatcher;
    private boolean failed;

    public ChannelErrorHandler(Logging logging) {
        this.log = logging.getLog(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.messageDispatcher = Objects.requireNonNull(ChannelAttributes.messageDispatcher(ctx.channel()));
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.messageDispatcher = null;
        this.failed = false;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.log.debug("Channel inactive: %s", ctx.channel());
        if (!this.failed) {
            ServiceUnavailableException error = new ServiceUnavailableException("Connection to the database terminated. This can happen due to network instabilities, or due to restarts of the database");
            this.fail(ctx, error);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        if (this.failed) {
            this.log.warn("Another fatal error in the pipeline of " + ctx.channel(), error);
        } else {
            this.failed = true;
            this.log.error("Fatal error in the pipeline of " + ctx.channel(), error);
            this.fail(ctx, error);
        }
    }

    private void fail(ChannelHandlerContext ctx, Throwable error) {
        Throwable cause = this.transformError(error);
        this.messageDispatcher.handleFatalError(cause);
        this.log.debug("Closing channel because of an error: %s", ctx.channel());
        ctx.close();
    }

    private Throwable transformError(Throwable error) {
        if (error instanceof CodecException) {
            error = error.getCause();
        }
        if (error instanceof IOException) {
            return new ServiceUnavailableException("Connection to the database failed", error);
        }
        return error;
    }
}

