/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.ResultResourcesHandler;
import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.async.AsyncConnection;
import org.neo4j.driver.internal.async.QueryRunner;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;

public class RoutingProcedureRunner {
    static final String GET_SERVERS = "dbms.cluster.routing.getServers";
    static final String GET_ROUTING_TABLE_PARAM = "context";
    static final String GET_ROUTING_TABLE = "dbms.cluster.routing.getRoutingTable({context})";
    private final RoutingContext context;

    public RoutingProcedureRunner(RoutingContext context) {
        this.context = context;
    }

    public RoutingProcedureResponse run(Connection connection) {
        Statement procedure = this.procedureStatement(ServerVersion.version(connection.server().version()));
        try {
            return new RoutingProcedureResponse(procedure, this.runProcedure(connection, procedure));
        }
        catch (ClientException error) {
            return new RoutingProcedureResponse(procedure, error);
        }
    }

    public CompletionStage<RoutingProcedureResponse> run(CompletionStage<AsyncConnection> connectionStage) {
        return connectionStage.thenCompose(connection -> {
            Statement procedure = this.procedureStatement(connection.serverVersion());
            return this.runProcedure((AsyncConnection)connection, procedure).handle((records, error) -> {
                if (error != null) {
                    return this.handleError(procedure, (Throwable)error);
                }
                return new RoutingProcedureResponse(procedure, (List<Record>)records);
            });
        });
    }

    List<Record> runProcedure(Connection connection, Statement procedure) {
        return NetworkSession.run(connection, procedure, ResultResourcesHandler.NO_OP).list();
    }

    CompletionStage<List<Record>> runProcedure(AsyncConnection connection, Statement procedure) {
        return QueryRunner.runAsync(connection, procedure).thenCompose(StatementResultCursor::listAsync);
    }

    private Statement procedureStatement(ServerVersion serverVersion) {
        if (serverVersion.greaterThanOrEqual(ServerVersion.v3_2_0)) {
            return new Statement("CALL dbms.cluster.routing.getRoutingTable({context})", Values.parameters(GET_ROUTING_TABLE_PARAM, this.context.asMap()));
        }
        return new Statement("CALL dbms.cluster.routing.getServers");
    }

    private RoutingProcedureResponse handleError(Statement procedure, Throwable error) {
        if (error instanceof ClientException) {
            return new RoutingProcedureResponse(procedure, error);
        }
        throw new CompletionException(error);
    }
}

