/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.async.AsyncConnection;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.ClusterCompositionResponse;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.cluster.RoutingProcedureRunner;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.exceptions.ProtocolException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.value.ValueException;

public class RoutingProcedureClusterCompositionProvider
implements ClusterCompositionProvider {
    private static final String PROTOCOL_ERROR_MESSAGE = "Failed to parse '%s' result received from server due to ";
    private final Clock clock;
    private final Logger log;
    private final RoutingProcedureRunner routingProcedureRunner;

    public RoutingProcedureClusterCompositionProvider(Clock clock, Logger log, RoutingSettings settings) {
        this(clock, log, new RoutingProcedureRunner(settings.routingContext()));
    }

    RoutingProcedureClusterCompositionProvider(Clock clock, Logger log, RoutingProcedureRunner routingProcedureRunner) {
        this.clock = clock;
        this.log = log;
        this.routingProcedureRunner = routingProcedureRunner;
    }

    @Override
    public ClusterCompositionResponse getClusterComposition(Connection connection) {
        RoutingProcedureResponse response = this.routingProcedureRunner.run(connection);
        return this.processRoutingResponse(response);
    }

    @Override
    public CompletionStage<ClusterCompositionResponse> getClusterComposition(CompletionStage<AsyncConnection> connectionStage) {
        return this.routingProcedureRunner.run(connectionStage).thenApply(this::processRoutingResponse);
    }

    private ClusterCompositionResponse processRoutingResponse(RoutingProcedureResponse response) {
        ClusterComposition cluster;
        if (!response.isSuccess()) {
            return new ClusterCompositionResponse.Failure(new ServiceUnavailableException(String.format("Failed to run '%s' on server. Please make sure that there is a Neo4j 3.1+ causal cluster up running.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response)), response.error()));
        }
        List<Record> records = response.records();
        this.log.info("Got getServers response: %s", records);
        long now = this.clock.millis();
        if (records.size() != 1) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("Failed to parse '%s' result received from server due to records received '%s' is too few or too many.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response), records.size())));
        }
        try {
            cluster = ClusterComposition.parse(records.get(0), now);
        }
        catch (ValueException e) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("Failed to parse '%s' result received from server due to unparsable record received.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response)), e));
        }
        if (!cluster.hasRoutersAndReaders()) {
            return new ClusterCompositionResponse.Failure(new ProtocolException(String.format("Failed to parse '%s' result received from server due to no router or reader found in response.", RoutingProcedureClusterCompositionProvider.invokedProcedureString(response))));
        }
        return new ClusterCompositionResponse.Success(cluster);
    }

    private static String invokedProcedureString(RoutingProcedureResponse response) {
        Statement statement = response.procedure();
        return statement.text() + " " + statement.parameters();
    }
}

