/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import java.util.Objects;
import org.neo4j.driver.internal.async.AsyncConnector;
import org.neo4j.driver.internal.net.BoltServerAddress;

public class NettyChannelPool
extends FixedChannelPool {
    private static final int MAX_PENDING_ACQUIRES = Integer.MAX_VALUE;
    private static final boolean RELEASE_HEALTH_CHECK = true;
    private final BoltServerAddress address;
    private final AsyncConnector connector;

    public NettyChannelPool(BoltServerAddress address, AsyncConnector connector, Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck, long acquireTimeoutMillis, int maxConnections) {
        super(bootstrap, handler, healthCheck, FixedChannelPool.AcquireTimeoutAction.FAIL, acquireTimeoutMillis, maxConnections, Integer.MAX_VALUE, true);
        this.address = Objects.requireNonNull(address);
        this.connector = Objects.requireNonNull(connector);
    }

    protected ChannelFuture connectChannel(Bootstrap bootstrap) {
        ChannelFuture channelFuture = this.connector.connect(this.address, bootstrap);
        channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                this.handler().channelCreated(channelFuture.channel());
            }
        });
        return channelFuture;
    }
}

